/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.item.parser;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.function.ItemMetaParser;
import dev.aurelium.slate.item.provider.KeyedItemProvider;
import dev.aurelium.slate.lore.LoreFactory;
import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.util.NumberUtil;
import dev.aurelium.slate.util.SkullCreator;
import dev.aurelium.slate.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class ConfigurateItemParser {
    private final Slate slate;
    private final Plugin plugin;

    public ConfigurateItemParser(Slate slate) {
        this.slate = slate;
        this.plugin = slate.getPlugin();
    }

    public ItemStack parseBaseItem(ConfigurationNode config) {
        ItemStack item;
        String key = config.node(new Object[]{"key"}).getString();
        if (key != null && (item = this.parseItemKey(key)) != null) {
            return item;
        }
        String materialString = config.node(new Object[]{"material"}).getString();
        Validate.notNull(materialString, "Item must specify a material");
        ItemStack item2 = this.parseMaterialString(materialString);
        this.parseAmount(item2, config);
        ItemMeta meta = item2.getItemMeta();
        if (meta == null) {
            return item2;
        }
        if (!config.node(new Object[]{"enchantments"}).virtual()) {
            this.parseEnchantments(item2, config);
        }
        if (!config.node(new Object[]{"custom_effects"}).virtual()) {
            this.parseCustomEffects(config, item2);
        }
        if (config.node(new Object[]{"glow"}).getBoolean(false)) {
            this.parseGlow(item2);
        }
        if (!config.node(new Object[]{"flags"}).virtual()) {
            this.parseFlags(config, item2);
        }
        if (!config.node(new Object[]{"durability"}).virtual()) {
            this.parseDurability(config, item2);
        }
        this.parseCustomModelData(config, item2);
        ConfigurationNode skullMetaSection = config.node(new Object[]{"skull_meta"});
        if (!skullMetaSection.virtual()) {
            this.parseSkullMeta(item2, item2.getItemMeta(), skullMetaSection);
        }
        for (Map.Entry<String, ItemMetaParser> entry : this.slate.getOptions().itemMetaParsers().entrySet()) {
            ConfigurationNode section = config.node(new Object[]{entry.getKey()});
            if (section.virtual()) continue;
            item2 = entry.getValue().parse(item2, section);
        }
        return item2;
    }

    @Nullable
    private ItemStack parseItemKey(String key) {
        KeyedItemProvider provider = this.slate.getOptions().keyedItemProvider();
        if (provider != null) {
            return provider.getItem(key);
        }
        return null;
    }

    private void parseDurability(ConfigurationNode section, ItemStack item) {
        ItemMeta meta = this.getMeta(item);
        int durability = section.node(new Object[]{"durability"}).getInt();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            short maxDurability = item.getType().getMaxDurability();
            damageable.setDamage(Math.max(maxDurability - durability, maxDurability));
            item.setItemMeta(meta);
        }
    }

    private void parseFlags(ConfigurationNode section, ItemStack item) {
        try {
            ItemMeta meta = this.getMeta(item);
            List flags = section.node(new Object[]{"flags"}).getList(String.class, new ArrayList());
            for (String flagName : flags) {
                ItemFlag itemFlag = ItemFlag.valueOf((String)flagName.toUpperCase(Locale.ROOT));
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
            item.setItemMeta(meta);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    private void parseGlow(ItemStack item) {
        ItemMeta meta = this.getMeta(item);
        meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
    }

    private void parseCustomEffects(ConfigurationNode section, ItemStack item) {
        PotionMeta potionMeta = (PotionMeta)this.getMeta(item);
        for (ConfigurationNode effectNode : section.node(new Object[]{"custom_effects"}).childrenList()) {
            String effectName = effectNode.node(new Object[]{"type"}).getString("SPEED");
            PotionEffectType type = PotionEffectType.getByName((String)effectName);
            if (type != null) {
                int duration = effectNode.node(new Object[]{"duration"}).getInt();
                int amplifier = effectNode.node(new Object[]{"amplifier"}).getInt();
                potionMeta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
                potionMeta.setColor(type.getColor());
                continue;
            }
            throw new IllegalArgumentException("Invalid potion effect type " + effectName);
        }
        item.setItemMeta((ItemMeta)potionMeta);
    }

    private void parseEnchantments(ItemStack item, ConfigurationNode section) {
        try {
            ItemMeta meta = this.getMeta(item);
            List enchantmentStrings = section.node(new Object[]{"enchantments"}).getList(String.class, new ArrayList());
            for (String enchantmentEntry : enchantmentStrings) {
                Enchantment enchantment;
                String[] splitEntry = enchantmentEntry.split(" ");
                String enchantmentName = splitEntry[0];
                int level = 1;
                if (splitEntry.length > 1) {
                    level = NumberUtil.toInt(splitEntry[1], 1);
                }
                if ((enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)enchantmentName.toLowerCase(Locale.ROOT)))) != null) {
                    if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta) {
                        EnchantmentStorageMeta esm = (EnchantmentStorageMeta)meta;
                        esm.addStoredEnchant(enchantment, level, true);
                        item.setItemMeta((ItemMeta)esm);
                        continue;
                    }
                    meta.addEnchant(enchantment, level, true);
                    item.setItemMeta(meta);
                    continue;
                }
                throw new IllegalArgumentException("Invalid enchantment name " + enchantmentName);
            }
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    private ItemStack parseMaterialString(String materialString) {
        String materialName = materialString.toUpperCase(Locale.ROOT);
        Material material = this.parseMaterial(materialName);
        if (material == null) {
            throw new IllegalArgumentException("Unknown material " + materialString);
        }
        if (!material.isItem()) {
            return new ItemStack(Material.GRAY_DYE);
        }
        ItemStack item = new ItemStack(material);
        return item;
    }

    @NotNull
    private ItemMeta getMeta(ItemStack item) {
        return Objects.requireNonNull(item.getItemMeta());
    }

    @Nullable
    public String parseDisplayName(ConfigurationNode section) {
        if (!section.node(new Object[]{"display_name"}).virtual()) {
            return section.node(new Object[]{"display_name"}).getString();
        }
        return null;
    }

    @NotNull
    public List<LoreLine> parseLore(ConfigurationNode section) {
        ConfigurationNode loreNode = section.node(new Object[]{"lore"});
        return new LoreFactory(this.slate).getLore(loreNode);
    }

    protected Material parseMaterial(String name) {
        return Material.getMaterial((String)name);
    }

    private void parseSkullMeta(ItemStack item, ItemMeta meta, ConfigurationNode section) {
        String placeholder;
        String url;
        String base64;
        if (!(meta instanceof SkullMeta)) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        String uuid = section.node(new Object[]{"uuid"}).getString();
        if (uuid != null) {
            UUID id = UUID.fromString(uuid);
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
            item.setItemMeta(meta);
        }
        if ((base64 = section.node(new Object[]{"base64"}).getString()) != null) {
            SkullCreator.itemWithBase64(item, base64);
        }
        if ((url = section.node(new Object[]{"url"}).getString()) != null) {
            SkullCreator.itemWithUrl(item, url);
        }
        if ((placeholder = section.node(new Object[]{"placeholder_uuid"}).getString()) != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey(this.plugin, "skull_placeholder_uuid");
            container.set(key, PersistentDataType.STRING, (Object)placeholder);
            item.setItemMeta(meta);
        }
    }

    private void parseAmount(ItemStack item, ConfigurationNode section) {
        int amount = section.node(new Object[]{"amount"}).getInt(1);
        item.setAmount(amount);
    }

    private void parseCustomModelData(ConfigurationNode config, ItemStack item) {
        if (!config.node(new Object[]{"custom_model_data"}).virtual()) {
            int data = config.node(new Object[]{"custom_model_data"}).getInt();
            ItemMeta meta = this.getMeta(item);
            meta.setCustomModelData(Integer.valueOf(data));
            item.setItemMeta(meta);
        } else if (!config.node(new Object[]{"nbt"}).node(new Object[]{"CustomModelData"}).virtual()) {
            int data = config.node(new Object[]{"nbt"}).node(new Object[]{"CustomModelData"}).getInt();
            ItemMeta meta = this.getMeta(item);
            meta.setCustomModelData(Integer.valueOf(data));
            item.setItemMeta(meta);
        }
    }
}

