/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberUtil {
    private static final NumberFormat zero = new DecimalFormat("#");
    private static final NumberFormat one = new DecimalFormat("#.#");
    private static final NumberFormat two = new DecimalFormat("#.##");

    public static String format0(double input) {
        return zero.format(input);
    }

    public static String format1(double input) {
        return one.format(input);
    }

    public static String format2(double input) {
        return two.format(input);
    }

    public static int toInt(String str) {
        return NumberUtil.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static short toShort(String str) {
        return NumberUtil.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static {
        zero.setRoundingMode(RoundingMode.HALF_UP);
        one.setRoundingMode(RoundingMode.HALF_UP);
        two.setRoundingMode(RoundingMode.HALF_UP);
    }
}

