/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.context;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import dev.aurelium.slate.context.ContextProvider;
import dev.aurelium.slate.context.DefaultContextProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ContextManager {
    private final Map<Class<?>, ContextProvider<?>> contexts = new HashMap();
    private final Map<String, ContextProvider<?>> keyedContexts = new HashMap();

    public ContextManager() {
        this.registerDefaults();
    }

    public <C> void registerContext(ContextProvider<C> provider) {
        this.contexts.put(provider.getType(), provider);
    }

    public <C> void registerContext(String key, ContextProvider<C> provider) {
        this.registerContext(provider);
        this.keyedContexts.put(key, provider);
    }

    @Nullable
    public ContextProvider<?> getContextProvider(Class<?> contextClass) {
        return this.contexts.get(contextClass);
    }

    @Nullable
    public ContextProvider<?> getContextProvider(String key) {
        return this.keyedContexts.get(key);
    }

    @Nullable
    public Class<?> getContextClass(String key) {
        ContextProvider<?> provider = this.getContextProvider(key);
        if (provider != null) {
            for (Map.Entry<Class<?>, ContextProvider<?>> entry : this.contexts.entrySet()) {
                if (!provider.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void registerDefaults() {
        this.registerContext(new DefaultContextProvider<Integer>(Integer.class, (menuName, input) -> Ints.tryParse((String)input)));
        this.registerContext(new DefaultContextProvider<Long>(Long.class, (menuName, input) -> Longs.tryParse((String)input)));
        this.registerContext(new DefaultContextProvider<Float>(Float.class, (menuName, input) -> Floats.tryParse((String)input)));
        this.registerContext(new DefaultContextProvider<Double>(Double.class, (menuName, input) -> Doubles.tryParse((String)input)));
        this.registerContext(new DefaultContextProvider<Short>(Short.class, (menuName, input) -> {
            Integer integer = Ints.tryParse((String)input);
            if (integer != null) {
                return (short)integer.intValue();
            }
            return null;
        }));
        this.registerContext(new DefaultContextProvider<Byte>(Byte.class, (menuName, input) -> {
            Integer integer = Ints.tryParse((String)input);
            if (integer != null) {
                return (byte)integer.intValue();
            }
            return null;
        }));
        this.registerContext(new DefaultContextProvider<Boolean>(Boolean.class, (menuName, input) -> input.equalsIgnoreCase("true")));
        this.registerContext(new DefaultContextProvider<Character>(Character.class, (menuName, input) -> {
            if (input.length() == 1) {
                return Character.valueOf(input.toCharArray()[0]);
            }
            return null;
        }));
        this.registerContext(new DefaultContextProvider<String>(String.class, (menuName, input) -> input));
    }
}

