/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.menu;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.action.trigger.MenuTrigger;
import dev.aurelium.slate.builder.BuiltTemplate;
import dev.aurelium.slate.component.ComponentParser;
import dev.aurelium.slate.component.MenuComponent;
import dev.aurelium.slate.fill.FillData;
import dev.aurelium.slate.fill.FillItem;
import dev.aurelium.slate.fill.FillItemParser;
import dev.aurelium.slate.fill.SlotParser;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.parser.SingleItemParser;
import dev.aurelium.slate.item.parser.TemplateItemParser;
import dev.aurelium.slate.menu.LoadedMenu;
import dev.aurelium.slate.util.YamlLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.plugin.Plugin;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class MenuLoader {
    private final Slate slate;
    private final File mainDir;
    private final List<File> mergeDirs;
    private final YamlLoader loader;

    public MenuLoader(Slate slate, File mainDir, List<File> mergeDirs) {
        this.slate = slate;
        this.mainDir = mainDir;
        this.mergeDirs = mergeDirs;
        this.loader = new YamlLoader((Plugin)slate.getPlugin());
    }

    public int loadMenus() {
        File[] files = this.mainDir.listFiles((d, name) -> name.endsWith(".yml"));
        if (files == null) {
            return 0;
        }
        int menusLoaded = 0;
        HashSet<String> mainLoaded = new HashSet<String>();
        for (File menuFile : files) {
            try {
                String menuName = this.loadAndAddMenu(menuFile);
                ++menusLoaded;
                mainLoaded.add(menuName);
            }
            catch (RuntimeException | ConfigurateException e) {
                this.slate.getPlugin().getLogger().warning("Error loading menu file " + menuFile.getName());
                e.printStackTrace();
            }
        }
        return menusLoaded += this.loadExternalMenus(mainLoaded);
    }

    private int loadExternalMenus(Set<String> mainLoaded) {
        int menusLoaded = 0;
        for (File mergeDir : this.mergeDirs) {
            File[] files;
            if (!mergeDir.isDirectory() || (files = mergeDir.listFiles((d, name) -> name.endsWith(".yml"))) == null) continue;
            for (File menuFile : files) {
                String menuName = menuFile.getName().substring(0, menuFile.getName().lastIndexOf("."));
                if (mainLoaded.contains(menuName)) continue;
                try {
                    this.loadAndAddMenu(menuFile);
                    ++menusLoaded;
                }
                catch (ConfigurateException e) {
                    this.slate.getPlugin().getLogger().warning("Error loading menu file " + menuFile.getName());
                    e.printStackTrace();
                }
            }
        }
        return menusLoaded;
    }

    private String loadAndAddMenu(File file) throws ConfigurateException, RuntimeException {
        String menuName = file.getName();
        int pos = menuName.lastIndexOf(".");
        if (pos > 0) {
            menuName = menuName.substring(0, pos);
        }
        LoadedMenu menu = this.loadMenu(file, menuName);
        this.slate.addLoadedMenu(menu);
        return menuName;
    }

    private ConfigurationNode mergeAndLoad(File mainFile) throws ConfigurateException {
        ConfigurationNode base = this.loader.loadUserFile(mainFile);
        ArrayList<ConfigurationNode> nodesToMerge = new ArrayList<ConfigurationNode>();
        nodesToMerge.add(base);
        for (File mergeDir : this.mergeDirs) {
            File[] files;
            if (!mergeDir.isDirectory() || (files = mergeDir.listFiles((d, name) -> name.equals(mainFile.getName()))) == null || files.length == 0) continue;
            File mergingFile = files[0];
            ConfigurationNode mergingNode = this.loader.loadUserFile(mergingFile);
            nodesToMerge.add(mergingNode);
        }
        return this.loader.mergeNodes(nodesToMerge.toArray(new ConfigurationNode[0]));
    }

    private LoadedMenu loadMenu(File file, String menuName) throws ConfigurateException, RuntimeException {
        FillData fillData;
        ConfigurationNode fillSection;
        ConfigurationNode templatesSection;
        ConfigurationNode config = this.mergeAndLoad(file);
        String title = config.node(new Object[]{"title"}).getString(menuName);
        int size = config.node(new Object[]{"size"}).getInt(6);
        LinkedHashMap<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
        ConfigurationNode itemsSection = config.node(new Object[]{"items"});
        if (!itemsSection.virtual()) {
            for (Object keyObj : itemsSection.childrenMap().keySet()) {
                String itemName = (String)Objects.requireNonNull(keyObj);
                ConfigurationNode itemSection = itemsSection.node(new Object[]{keyObj});
                if (itemSection.virtual()) continue;
                MenuItem item = new SingleItemParser(this.slate).parse(itemSection, menuName);
                items.put(itemName, item);
            }
        }
        if (!(templatesSection = config.node(new Object[]{"templates"})).virtual()) {
            for (Object keyObj : templatesSection.childrenMap().keySet()) {
                String templateName = (String)Objects.requireNonNull(keyObj);
                ConfigurationNode templateSection = templatesSection.node(new Object[]{keyObj});
                if (templateSection.virtual()) continue;
                Object contextProvider = null;
                BuiltTemplate<?> builtTemplate = this.slate.getBuiltMenu(menuName).templates().get(templateName);
                if (builtTemplate != null) {
                    contextProvider = this.slate.getContextManager().getContextProvider(builtTemplate.contextType());
                }
                if (contextProvider == null) continue;
                MenuItem item = new TemplateItemParser(this.slate, contextProvider).parse(templateSection, menuName);
                items.put(templateName, item);
            }
        }
        if (!(fillSection = config.node(new Object[]{"fill"})).virtual()) {
            boolean fillEnabled = fillSection.node(new Object[]{"enabled"}).getBoolean(false);
            FillItem fillItem = new FillItemParser(this.slate).parse(fillSection, menuName);
            fillData = new FillData(fillItem, new SlotParser().parse(fillSection, size), fillEnabled);
        } else {
            fillData = new FillData(FillItem.getDefault(this.slate), null, false);
        }
        HashMap<String, MenuComponent> components = new HashMap<String, MenuComponent>();
        ConfigurationNode componentsSection = config.node(new Object[]{"components"});
        if (!componentsSection.virtual()) {
            for (Object keyObj : componentsSection.childrenMap().keySet()) {
                String name = (String)Objects.requireNonNull(keyObj);
                ConfigurationNode componentNode = componentsSection.node(new Object[]{keyObj});
                if (componentNode.virtual()) continue;
                components.put(name, new ComponentParser(this.slate).parse(componentNode));
            }
        }
        HashMap<String, String> formats = new HashMap<String, String>();
        for (Object keyObj : config.node(new Object[]{"formats"}).childrenMap().keySet()) {
            String key = (String)keyObj;
            String value = config.node(new Object[]{"formats"}).node(new Object[]{keyObj}).getString();
            if (value == null) continue;
            formats.put(key, value);
        }
        this.generateDefaultOptions(menuName, file, config);
        Map<String, Object> options = MenuLoader.loadOptions(config);
        Map<MenuTrigger, List<Action>> actions = this.loadActions(config, menuName);
        return new LoadedMenu(menuName, title, size, items, components, formats, fillData, options, actions);
    }

    private Map<MenuTrigger, List<Action>> loadActions(ConfigurationNode config, String menuName) {
        LinkedHashMap<MenuTrigger, List<Action>> actions = new LinkedHashMap<MenuTrigger, List<Action>>();
        for (MenuTrigger menuTrigger : MenuTrigger.values()) {
            String id = menuTrigger.getId();
            if (config.node(new Object[]{id}).virtual()) continue;
            List<Action> clickActions = this.slate.getActionManager().parseActions(config.node(new Object[]{id}), menuName);
            actions.put(menuTrigger, clickActions);
        }
        return actions;
    }

    private void generateDefaultOptions(String menuName, File file, ConfigurationNode mainConfig) throws SerializationException {
        Map<String, Object> defaultOptions = this.slate.getBuiltMenu(menuName).defaultOptions();
        if (defaultOptions == null) {
            return;
        }
        ConfigurationNode config = mainConfig.node(new Object[]{"options"});
        boolean changed = false;
        for (Map.Entry<String, Object> entry : defaultOptions.entrySet()) {
            if (!config.node(new Object[]{entry.getKey()}).virtual()) continue;
            config.node(new Object[]{entry.getKey()}).set(entry.getValue());
            if (changed) continue;
            changed = true;
        }
        if (changed) {
            try {
                this.loader.saveFile(file, mainConfig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> loadOptions(ConfigurationNode config) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        ConfigurationNode optionSection = config.node(new Object[]{"options"});
        for (Object keyObj : optionSection.childrenMap().keySet()) {
            String key = (String)keyObj;
            if (optionSection.node(new Object[]{keyObj}).isMap()) continue;
            Object value = optionSection.node(new Object[]{key}).raw();
            options.put(key, value);
        }
        return options;
    }
}

