/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.menu;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.builder.BuiltMenu;
import dev.aurelium.slate.inv.InventoryListener;
import dev.aurelium.slate.inv.SmartInventory;
import dev.aurelium.slate.menu.LoadedMenu;
import dev.aurelium.slate.menu.MenuInventory;
import dev.aurelium.slate.text.TextFormatter;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class MenuOpener {
    private final Slate slate;
    private final TextFormatter tf = new TextFormatter();

    public MenuOpener(Slate slate) {
        this.slate = slate;
    }

    public void openMenu(Player player, String name, Map<String, Object> properties, int page) {
        try {
            this.openMenuUnchecked(player, name, properties, page);
        }
        catch (Exception e) {
            player.closeInventory();
            this.slate.getPlugin().getLogger().warning("Error opening Slate menu " + name);
            e.printStackTrace();
        }
    }

    public void openMenuUnchecked(Player player, String name, Map<String, Object> properties, int page) {
        LoadedMenu menu = this.slate.getLoadedMenu(name);
        if (menu == null) {
            throw new IllegalArgumentException("Menu with name " + name + " not registered");
        }
        MenuInventory menuInventory = new MenuInventory(this.slate, menu, player, properties, page);
        String title = menu.title();
        BuiltMenu builtMenu = this.slate.getBuiltMenu(name);
        title = builtMenu.applyTitleReplacers(title, this.slate, player, menuInventory.getActiveMenu());
        if (this.slate.isPlaceholderAPIEnabled()) {
            title = PlaceholderAPI.setPlaceholders((Player)player, (String)title);
        }
        if (((Boolean)menu.options().getOrDefault("format_title", true)).booleanValue()) {
            title = this.tf.toString(this.tf.toComponent(title));
        }
        SmartInventory smartInventory = SmartInventory.builder().title(title).size(menu.size(), 9).manager(this.slate.getInventoryManager()).provider(menuInventory).listener(new InventoryListener<InventoryCloseEvent>(InventoryCloseEvent.class, menuInventory::close)).build();
        smartInventory.open(player);
    }

    public void openMenu(Player player, String name, Map<String, Object> properties) {
        this.openMenu(player, name, properties, 0);
    }

    public void openMenu(Player player, String name, int page) {
        this.openMenu(player, name, new HashMap<String, Object>(), page);
    }

    public void openMenu(Player player, String name) {
        this.openMenu(player, name, new HashMap<String, Object>(), 0);
    }
}

