/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.logging;

import dev.bitbite.logging.Category;
import dev.bitbite.logging.LogLevel;
import dev.bitbite.logging.LogLevels;
import dev.bitbite.logging.LogMessage;
import dev.bitbite.logging.LogProperties;
import java.util.Date;
import java.util.Map;

public abstract class Log {
    protected LogProperties properties = new LogProperties();

    protected Log() {
    }

    protected String format(LogLevel logLevel, Category category, String message) {
        String modify = this.properties.getLogTemplate();
        for (Map.Entry<String, String> template : this.properties.getTemplates().entrySet()) {
            modify = modify.replace(template.getKey(), !template.getValue().contains("\u001b[") || this.properties.usesAnsi() ? (CharSequence)template.getValue() : "");
        }
        return this.replaceDynamicElements(logLevel, category, message, modify);
    }

    private String replaceDynamicElements(LogLevel logLevel, Category category, String message, String preFormattedString) {
        String string = logLevel != null ? preFormattedString.replace("${loglevelformat}", this.properties.usesAnsi() ? logLevel.ansi.toString() : "") : (preFormattedString = preFormattedString.replace("${loglevelformat}", ""));
        preFormattedString = category != null ? preFormattedString.replace("${categoryformat}", this.properties.usesAnsi() ? category.ansi.toString() : "") : preFormattedString.replace("${categoryformat}", "");
        preFormattedString = logLevel != null ? preFormattedString.replace("${loglevelname}", logLevel.name) : preFormattedString.replace("${loglevelname}", "");
        preFormattedString = category != null ? preFormattedString.replace("{categoryname}", category.name) : preFormattedString.replace("{categoryname}", "");
        preFormattedString = preFormattedString.replace("[]", "");
        preFormattedString = preFormattedString.replace("${datetime}", this.properties.getDateTimeFormat().format(new Date()));
        preFormattedString = preFormattedString.replace("${date}", this.properties.getDateFormat().format(new Date()));
        preFormattedString = preFormattedString.replace("${time}", this.properties.getTimeFormat().format(new Date()));
        return preFormattedString.replace("${message}", message);
    }

    public LogProperties getProperties() {
        return this.properties;
    }

    public void setProperties(LogProperties properties) {
        this.properties = properties;
    }

    public abstract String log(LogMessage var1);

    public String debug(String message) {
        return this.log(new LogMessage(LogLevels.DEBUG, null, message, null));
    }

    public String info(String message) {
        return this.log(new LogMessage(LogLevels.INFO, null, message, null));
    }

    public String warning(String message) {
        return this.log(new LogMessage(LogLevels.WARNING, null, message, null));
    }

    public String error(String message) {
        return this.log(new LogMessage(LogLevels.ERROR, null, message, null));
    }

    public String critical(String message) {
        return this.log(new LogMessage(LogLevels.CRITICAL, null, message, null));
    }
}

