/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.logging;

import dev.thatsnasu.ansi.Color;
import dev.thatsnasu.ansi.Color3b;
import dev.thatsnasu.ansi.Color4b;
import dev.thatsnasu.ansi.Color8b;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class LogProperties {
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private HashMap<String, String> templates = new HashMap();
    private boolean usesAnsi;
    private String logTemplate;

    public LogProperties() {
        this.templates.put("${delimiteropen}", "[");
        this.templates.put("${delimiterclose}", "]");
        this.templates.put("${defaultcolor}", Color3b.RESET.toString());
        this.templates.put("${metadataseparator}", ": ");
        this.templates.put("${resetformat}", Color3b.RESET.toString());
        this.logTemplate = "${defaultcolor}${delimiteropen}${datetime}${delimiterclose}${loglevelformat}${delimiteropen}${loglevelname}${delimiterclose}${categoryformat}${delimiteropen}{categoryname}${delimiterclose}${defaultcolor}${metadataseparator}${message}${resetformat}";
    }

    public SimpleDateFormat getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public String getLogTemplate() {
        return this.logTemplate;
    }

    public HashMap<String, String> getTemplates() {
        return this.templates;
    }

    public boolean usesAnsi() {
        return this.usesAnsi;
    }

    public void setDateTimeFormat(SimpleDateFormat dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setLogTemplate(String template) {
        this.logTemplate = template;
    }

    public void usesAnsi(boolean usesAnsi) {
        this.usesAnsi = usesAnsi;
    }

    public void setTemplateElement(String templateKey, String templateValue) {
        if (this.templates.containsKey(templateKey)) {
            this.templates.replace(templateKey, templateValue);
        } else {
            this.templates.put(templateKey, templateValue);
        }
    }

    public void setDelimiter(String[] delimiter) {
        this.templates.replace("${delimiteropen}", delimiter[0]);
        this.templates.replace("${delimiterclose}", delimiter[1]);
    }

    public void setDelimiters(String openDelimiter, String closeDelimiter) {
        this.setDelimiter(new String[]{openDelimiter, closeDelimiter});
    }

    public void setDefaultColor(Color3b color3b) {
        this.setDefaultColor(new Color(color3b.getHexCode()));
    }

    public void setDefaultColor(Color4b color4b) {
        this.setDefaultColor(new Color(color4b.getHexCode()));
    }

    public void setDefaultColor(Color8b color8b) {
        this.setDefaultColor(new Color(color8b.getHexCode()));
    }

    public void setDefaultColor(Color color) {
        this.templates.replace("${defaultcolor}", color.toString());
    }
}

