/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.logging.log;

import dev.bitbite.logging.Log;
import dev.bitbite.logging.LogLevels;
import dev.bitbite.logging.LogMessage;
import java.util.ArrayList;

public class ConsoleLog
extends Log {
    public ConsoleLog(ArrayList<Log> logs) {
        logs.add(this);
    }

    public ConsoleLog() {
    }

    @Override
    public String log(LogMessage logMessage) {
        Object finalMessage = "";
        Object logContent = "";
        if (logMessage.message != null) {
            logContent = (String)logContent + logMessage.message;
        }
        if (logMessage != null && logMessage.exception != null) {
            logContent = (String)logContent + " ";
        }
        if (logMessage.exception != null) {
            StackTraceElement elem = logMessage.exception.getStackTrace()[0];
            logContent = (String)logContent + logMessage.exception.getMessage() + " in " + elem.getClassName() + ":" + elem.getLineNumber();
        }
        finalMessage = (String)finalMessage + this.format(logMessage.logLevel, logMessage.category, (String)logContent);
        if (logMessage.exception != null) {
            boolean first = true;
            finalMessage = (String)finalMessage + "\n";
            for (int i = 0; i < logMessage.exception.getStackTrace().length; ++i) {
                if (first) {
                    first = false;
                    continue;
                }
                StackTraceElement elem = logMessage.exception.getStackTrace()[i];
                finalMessage = (String)finalMessage + this.format(LogLevels.STACKTRACE, logMessage.category, elem.getClassName() + " in line " + elem.getLineNumber()) + "\n";
            }
        }
        System.out.println((String)finalMessage);
        return finalMessage;
    }
}

