/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.logging.log;

import dev.bitbite.logging.Log;
import dev.bitbite.logging.LogLevels;
import dev.bitbite.logging.LogMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;

public class FileLog
extends Log {
    private File logFile;
    private PrintWriter writer;

    public FileLog(File logFile, boolean append) throws FileNotFoundException {
        this.logFile = logFile;
        if (!Files.exists(this.logFile.toPath().toAbsolutePath().getParent(), new LinkOption[0])) {
            this.logFile.toPath().toAbsolutePath().getParent().toFile().mkdirs();
        }
        this.writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile, append)));
    }

    public FileLog(File logFile, boolean append, ArrayList<Log> logs) throws FileNotFoundException {
        this(logFile, append);
        logs.add(this);
    }

    public FileLog(String path, boolean append) throws FileNotFoundException {
        this(new File(path), append);
    }

    @Override
    public String log(LogMessage logMessage) {
        Object finalMessage = "";
        Object logContent = "";
        if (logMessage.message != null) {
            logContent = (String)logContent + logMessage.message;
        }
        if (logMessage != null && logMessage.exception != null) {
            logContent = (String)logContent + " ";
        }
        if (logMessage.exception != null) {
            StackTraceElement elem = logMessage.exception.getStackTrace()[0];
            logContent = (String)logContent + logMessage.exception.getMessage() + " in " + elem.getClassName() + ":" + elem.getLineNumber();
        }
        finalMessage = (String)finalMessage + this.format(logMessage.logLevel, logMessage.category, (String)logContent);
        if (logMessage.exception != null) {
            boolean first = true;
            finalMessage = (String)finalMessage + "\n";
            for (int i = 0; i < logMessage.exception.getStackTrace().length; ++i) {
                if (first) {
                    first = false;
                    continue;
                }
                StackTraceElement elem = logMessage.exception.getStackTrace()[i];
                finalMessage = (String)finalMessage + this.format(LogLevels.STACKTRACE, logMessage.category, elem.getClassName() + " in line " + elem.getLineNumber()) + "\n";
            }
        }
        this.writer.println((String)finalMessage);
        this.writer.flush();
        return finalMessage;
    }
}

