/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.CommunicationHandler;
import dev.bitbite.networking.Server;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.CopyOnWriteArrayList;

public class ClientManager
extends Thread {
    private boolean closing = false;
    private final Server server;
    private Thread readThread;
    private CopyOnWriteArrayList<CommunicationHandler> communicationHandler;

    public ClientManager(Server server) {
        this.server = server;
        this.communicationHandler = new CopyOnWriteArrayList();
    }

    @Override
    public void run() {
        this.server.notifyListeners(Server.EventType.ACCEPT_START, new Object[0]);
        this.readThread = new Thread(() -> {
            while (!this.readThread.isInterrupted()) {
                this.communicationHandler.forEach(ch -> ch.getIOHandler().read());
            }
        });
        this.readThread.setName("Data reader");
        this.readThread.start();
        while (!Thread.currentThread().isInterrupted()) {
            if (this.server.getServerSocket().isClosed()) {
                Thread.currentThread().interrupt();
                continue;
            }
            Socket clientSocket = null;
            try {
                clientSocket = this.server.getServerSocket().accept();
                if (clientSocket == null) continue;
                CommunicationHandler ch = new CommunicationHandler(clientSocket, this);
                ch.registerListener(this.server.getIOListeners());
                this.communicationHandler.add(ch);
                this.server.notifyListeners(Server.EventType.ACCEPT, ch);
            }
            catch (SocketTimeoutException e) {
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contentEquals("Socket operation on nonsocket: configureBlocking")) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (e.getMessage() == null || !e.getMessage().contentEquals("Interrupted function call: accept failed")) {
                    if (this.closing) continue;
                    this.server.notifyListeners(Server.EventType.ACCEPT_FAILED, e);
                }
                if (e.getMessage() == null || !e.getMessage().contentEquals("Socket is closed")) continue;
                if (clientSocket != null) {
                    this.server.notifyListeners(Server.EventType.SOCKET_CLOSED, e, clientSocket.getRemoteSocketAddress());
                } else {
                    this.server.notifyListeners(Server.EventType.SOCKET_CLOSED, e);
                }
                Thread.currentThread().interrupt();
            }
        }
        this.server.notifyListeners(Server.EventType.ACCEPT_END, new Object[0]);
    }

    public boolean close() {
        this.closing = true;
        Thread.currentThread().interrupt();
        if (this.readThread != null) {
            this.readThread.interrupt();
        }
        this.communicationHandler.forEach(ch -> ch.close());
        return true;
    }

    public CommunicationHandler getCommunicationHandlerByIP(String clientAddress) {
        for (CommunicationHandler ch : this.communicationHandler) {
            if (!ch.getIP().equals(clientAddress)) continue;
            return ch;
        }
        return null;
    }

    protected void removeCommunicationHandler(CommunicationHandler communicationHandler) {
        this.communicationHandler.remove(communicationHandler);
    }

    public Server getServer() {
        return this.server;
    }

    public CopyOnWriteArrayList<CommunicationHandler> getCommunicationHandler() {
        return this.communicationHandler;
    }
}

