/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.ClientManager;
import dev.bitbite.networking.CommunicationHandlerCloseListener;
import dev.bitbite.networking.DataPreProcessor;
import dev.bitbite.networking.IOHandler;
import dev.bitbite.networking.IOHandlerListener;
import dev.bitbite.networking.Server;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class CommunicationHandler {
    private Socket clientSocket;
    private ClientManager clientManager;
    private IOHandler iOHandler;

    public CommunicationHandler(Socket clientSocket, ClientManager clientManager) {
        this.clientSocket = clientSocket;
        this.clientManager = clientManager;
        try {
            this.iOHandler = new IOHandler(clientSocket.getInputStream(), clientSocket.getOutputStream(), this::processReceivedData);
            this.iOHandler.registerListener(new CommunicationHandlerCloseListener(this));
        }
        catch (IOException e) {
            this.clientManager.getServer().notifyListeners(Server.EventType.COMMUNICATIONHANDLER_INIT_FAILED, e);
        }
    }

    public void close() {
        this.clientManager.getServer().notifyListeners(Server.EventType.COMMUNICATIONHANDLER_CLOSE, this);
        try {
            this.iOHandler.close();
            this.clientSocket.close();
            this.clientManager.removeCommunicationHandler(this);
        }
        catch (Exception e) {
            this.clientManager.getServer().notifyListeners(Server.EventType.COMMUNICATIONHANDLER_CLOSE_FAILED, this, e);
        }
        this.clientManager.getServer().notifyListeners(Server.EventType.COMMUNICATIONHANDLER_CLOSE_END, this);
    }

    protected void send(byte[] data) {
        this.iOHandler.write(data);
    }

    public void flushRead() {
        this.iOHandler.flushRead();
    }

    public void readNBytes(int amount) {
        this.iOHandler.readToNBytes(amount);
    }

    protected void processReceivedData(byte[] data) {
        data = this.clientManager.getServer().getDataPreProcessor().process(DataPreProcessor.TransferMode.IN, data);
        this.clientManager.getServer().processReceivedData(this.getIP(), data);
    }

    public void registerListener(IOHandlerListener listener) {
        this.iOHandler.registerListener(listener);
    }

    public void registerListener(ArrayList<IOHandlerListener> listener) {
        listener.forEach(l -> this.iOHandler.registerListener((IOHandlerListener)l));
    }

    public String getIP() {
        return this.clientSocket.getRemoteSocketAddress().toString();
    }

    public IOHandler getIOHandler() {
        return this.iOHandler;
    }
}

