/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.Client;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DisconnectedServerDetector
extends Thread {
    private long MAX_READ_THRESHOLD = 5000000000L;
    private Client client;
    private ExecutorService executorService;

    public DisconnectedServerDetector(Client client) {
        this.client = client;
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            if (this.client.isClosed()) {
                Thread.currentThread().interrupt();
                continue;
            }
            if (this.client.getIOHandler().getTimeSinceLastRead() > this.MAX_READ_THRESHOLD) {
                Future<Boolean> future = this.executorService.submit(() -> {
                    Thread.currentThread().setName("[DDS] server checker");
                    this.client.getIOHandler().readNBytes(1);
                    return true;
                });
                try {
                    future.get(20L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    future.cancel(true);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Thread.currentThread().interrupt();
    }

    public void setMaxReadThreshold(long threshold) {
        this.MAX_READ_THRESHOLD = threshold;
    }

    public long getMAX_READ_THRESHOLD() {
        return this.MAX_READ_THRESHOLD;
    }
}

