/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.IOHandlerListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.function.Consumer;

public class IOHandler {
    private static byte END_OF_MESSAGE_BYTE = (byte)10;
    private static int MAX_READ_SIZE = 1024;
    private static boolean VERBOSE = false;
    private boolean closing = false;
    private boolean closed = false;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ArrayList<Byte> readBuffer;
    private Consumer<byte[]> readCallback;
    private ArrayList<IOHandlerListener> listeners;
    private long lastRead;

    public IOHandler(InputStream inputStream, OutputStream outputStream, Consumer<byte[]> onRead) {
        if (inputStream == null || outputStream == null || onRead == null) {
            throw new IllegalArgumentException("Parameters of IOHandler constructor must not be null");
        }
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.readBuffer = new ArrayList();
        this.readCallback = onRead;
        this.listeners = new ArrayList();
        this.lastRead = System.nanoTime();
    }

    public void close() {
        if (this.closing || this.closed) {
            return;
        }
        this.closing = true;
        this.notifyListeners(EventType.CLOSE_START, new Object[0]);
        try {
            this.outputStream.flush();
            this.outputStream.close();
            this.closed = true;
        }
        catch (Exception e) {
            this.notifyListeners(EventType.CLOSE_FAILED, e);
        }
        this.notifyListeners(EventType.CLOSE_END, new Object[0]);
    }

    public void read() {
        if (this.closing || this.closed) {
            return;
        }
        try {
            if (this.inputStream.available() > 0) {
                this.readNBytes(MAX_READ_SIZE);
            }
        }
        catch (SocketException e) {
            if (e.getMessage().contains("Connection reset") || e.getMessage().contains("Socket closed")) {
                this.close();
            } else {
                this.notifyListeners(EventType.DATA_READ_FAILED, e);
            }
        }
        catch (Exception e) {
            this.notifyListeners(EventType.DATA_READ_FAILED, e);
        }
    }

    protected void readNBytes(int amount) {
        if (this.closing || this.closed) {
            return;
        }
        try {
            for (int i = 0; i < amount; ++i) {
                int iRead = this.inputStream.read();
                this.lastRead = System.nanoTime();
                if (iRead == -1) {
                    this.close();
                    return;
                }
                byte read = Integer.valueOf(iRead).byteValue();
                if (read == END_OF_MESSAGE_BYTE) {
                    this.flushRead();
                    break;
                }
                this.readBuffer.add(read);
            }
        }
        catch (SocketException e) {
            if (e.getMessage().contains("Connection reset") || e.getMessage().contains("Socket closed")) {
                this.close();
            } else {
                this.notifyListeners(EventType.DATA_READ_FAILED, e);
            }
        }
        catch (Exception e) {
            this.notifyListeners(EventType.DATA_READ_FAILED, e);
        }
    }

    protected void readToNBytes(int total) {
        while (this.readBuffer.size() < total) {
            this.readNBytes(1);
        }
        this.flushRead();
    }

    protected void flushRead() {
        byte[] result = new byte[this.readBuffer.size()];
        for (int i = 0; i < this.readBuffer.size(); ++i) {
            result[i] = this.readBuffer.get(i);
        }
        this.readBuffer.clear();
        this.readCallback.accept(result);
    }

    public void write(byte[] data) {
        if (this.closing || this.closed) {
            return;
        }
        this.notifyListeners(EventType.WRITE, new Object[]{data});
        try {
            this.outputStream.write(data);
            this.outputStream.write(10);
            this.outputStream.flush();
        }
        catch (Exception e) {
            this.notifyListeners(EventType.WRITE_FAILED, e);
        }
        this.notifyListeners(EventType.WRITE_END, new Object[0]);
    }

    public void registerListener(IOHandlerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IOHandlerListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(EventType type, Object ... args) {
        if (VERBOSE && args.length > 0 && args[0] instanceof Exception) {
            ((Exception)args[0]).printStackTrace();
        }
        switch (type) {
            case DATA_READ_START: {
                this.listeners.forEach(l -> l.onDataReadStart());
                break;
            }
            case DATA_READ_END: {
                this.listeners.forEach(l -> l.onDataReadEnd());
                break;
            }
            case DATA_READ_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onDataReadFailed((Exception)args[0]));
                break;
            }
            case CLOSE_START: {
                this.listeners.forEach(l -> l.onCloseStart());
                break;
            }
            case CLOSE_END: {
                this.listeners.forEach(l -> l.onCloseEnd());
                break;
            }
            case CLOSE_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onCloseFailed((Exception)args[0]));
                break;
            }
            case WRITE: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type byte[], but got nothing");
                }
                if (!(args[0] instanceof byte[])) {
                    throw new IllegalArgumentException("Expected object of type byte[], but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onWrite((byte[])args[0]));
                break;
            }
            case WRITE_END: {
                this.listeners.forEach(l -> l.onWriteEnd());
                break;
            }
            case WRITE_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onWriteFailed((Exception)args[0]));
            }
        }
    }

    public long getTimeSinceLastRead() {
        return System.nanoTime() - this.lastRead;
    }

    public static byte getEndOfMessageByte() {
        return END_OF_MESSAGE_BYTE;
    }

    public static void setEndOfMessageByte(byte endOfMessageByte) {
        END_OF_MESSAGE_BYTE = endOfMessageByte;
    }

    public static int getMaxReadSize() {
        return MAX_READ_SIZE;
    }

    public static void setMaxReadSize(int maxReadSize) {
        MAX_READ_SIZE = maxReadSize;
    }

    public static boolean isVERBOSE() {
        return VERBOSE;
    }

    public static void setVERBOSE(boolean VERBOSE) {
        IOHandler.VERBOSE = VERBOSE;
    }

    public boolean isClosed() {
        return this.closed;
    }

    static enum EventType {
        DATA_READ_START,
        DATA_READ_END,
        DATA_READ_FAILED,
        CLOSE_START,
        CLOSE_END,
        CLOSE_FAILED,
        WRITE,
        WRITE_END,
        WRITE_FAILED;

    }
}

