/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.ClientManager;
import dev.bitbite.networking.CommunicationHandler;
import dev.bitbite.networking.DataPreProcessor;
import dev.bitbite.networking.DisconnectedClientDetector;
import dev.bitbite.networking.IOHandlerListener;
import dev.bitbite.networking.ServerListener;
import dev.bitbite.networking.exceptions.LayerDisableFailedException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;

public abstract class Server {
    public final int PORT;
    protected ServerSocket serverSocket;
    protected ClientManager clientManager;
    protected DataPreProcessor dataPreProcessor;
    protected DisconnectedClientDetector disconnectedClientDetector;
    protected ArrayList<ServerListener> listeners;
    protected ArrayList<IOHandlerListener> iOListeners;
    private int SO_TIMEOUT = 0;
    private static boolean VERBOSE = false;

    public Server(int port) {
        this.PORT = port;
        this.clientManager = new ClientManager(this);
        this.clientManager.setName("ClientManager");
        this.dataPreProcessor = new DataPreProcessor();
        this.disconnectedClientDetector = new DisconnectedClientDetector(this);
        this.disconnectedClientDetector.setName("Disconnected Client Detector");
        this.listeners = new ArrayList();
        this.iOListeners = new ArrayList();
    }

    public void start() {
        this.notifyListeners(EventType.START, new Object[0]);
        try {
            this.openServerSocket();
            this.serverSocket.setSoTimeout(this.SO_TIMEOUT);
            this.disconnectedClientDetector.start();
            this.dataPreProcessor.initLayers();
        }
        catch (Exception e) {
            this.notifyListeners(EventType.START_FAILED, e);
            return;
        }
        this.clientManager.start();
        this.notifyListeners(EventType.START_SUCCESS, new Object[0]);
    }

    protected void openServerSocket() throws IOException {
        this.serverSocket = new ServerSocket(this.PORT);
    }

    public void close() {
        this.notifyListeners(EventType.CLOSE, new Object[0]);
        this.clientManager.close();
        try {
            this.dataPreProcessor.shutdown();
            this.serverSocket.close();
            this.disconnectedClientDetector.interrupt();
        }
        catch (LayerDisableFailedException | IOException e) {
            this.notifyListeners(EventType.CLOSE_FAILED, e);
        }
        this.notifyListeners(EventType.CLOSE_END, new Object[0]);
    }

    protected abstract void processReceivedData(String var1, byte[] var2);

    public boolean send(String clientAddress, byte[] data) {
        data = this.dataPreProcessor.process(DataPreProcessor.TransferMode.OUT, data);
        this.clientManager.getCommunicationHandlerByIP(clientAddress).send(data);
        return true;
    }

    public void broadcast(byte[] data) {
        byte[] processedData = this.dataPreProcessor.process(DataPreProcessor.TransferMode.OUT, data);
        this.clientManager.getCommunicationHandler().forEach(ch -> ch.send(processedData));
    }

    public void registerListener(ServerListener listener) {
        this.listeners.add(listener);
    }

    public void registerListener(IOHandlerListener listener) {
        this.iOListeners.add(listener);
    }

    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListener(IOHandlerListener listener) {
        this.iOListeners.remove(listener);
    }

    protected void notifyListeners(EventType type, Object ... args) {
        if (VERBOSE && args.length > 0 && args[0] instanceof Exception) {
            ((Exception)args[0]).printStackTrace();
        }
        switch (type) {
            case START: {
                this.listeners.forEach(ServerListener::onStart);
                break;
            }
            case START_SUCCESS: {
                this.listeners.forEach(ServerListener::onStartSuccess);
                break;
            }
            case START_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onStartFailed((Exception)args[0]));
                break;
            }
            case ACCEPT: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type CommunicationHandler, but got nothing");
                }
                if (!(args[0] instanceof CommunicationHandler)) {
                    throw new IllegalArgumentException("Expected object of type CommunicationHandler, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onAccept((CommunicationHandler)args[0]));
                break;
            }
            case ACCEPT_END: {
                this.listeners.forEach(ServerListener::onAcceptEnd);
                break;
            }
            case ACCEPT_START: {
                this.listeners.forEach(ServerListener::onAcceptStart);
                break;
            }
            case ACCEPT_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onAcceptFailed((Exception)args[0]));
                break;
            }
            case SOCKET_CLOSED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (args.length == 1) {
                    if (!(args[0] instanceof Exception)) {
                        throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                    }
                    this.listeners.forEach(l -> l.onSocketClosed((Exception)args[0]));
                    break;
                }
                if (!(args[0] instanceof Exception) || !(args[1] instanceof String)) {
                    throw new IllegalArgumentException("Expected objects of type Exception and String, but got " + args[0].getClass().getSimpleName() + " and " + args[1].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onSocketClosed((Exception)args[0], (String)args[1]));
                break;
            }
            case CLOSE: {
                this.listeners.forEach(ServerListener::onClose);
                break;
            }
            case CLOSE_END: {
                this.listeners.forEach(ServerListener::onCloseEnd);
                break;
            }
            case CLOSE_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onCloseFailed((Exception)args[0]));
                break;
            }
            case COMMUNICATIONHANDLER_INIT_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onCommunicationHandlerInitFailed((Exception)args[0]));
                break;
            }
            case COMMUNICATIONHANDLER_CLOSE: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type CommunicationHandler, but got nothing");
                }
                if (!(args[0] instanceof CommunicationHandler)) {
                    throw new IllegalArgumentException("Expected object of type CommunicationHandler, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onCommunicationHandlerClose((CommunicationHandler)args[0]));
                break;
            }
            case COMMUNICATIONHANDLER_CLOSE_END: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type CommunicationHandler, but got nothing");
                }
                if (!(args[0] instanceof CommunicationHandler)) {
                    throw new IllegalArgumentException("Expected object of type CommunicationHandler, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onCommunicationHandlerCloseEnd((CommunicationHandler)args[0]));
                break;
            }
            case COMMUNICATIONHANDLER_CLOSE_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof CommunicationHandler) || !(args[1] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected objects of type CommunicationHandler and Exception, but got " + args[0].getClass().getSimpleName() + " and " + args[1].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onCommunicationHandlerCloseFailed((CommunicationHandler)args[0], (Exception)args[1]));
            }
        }
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    public DataPreProcessor getDataPreProcessor() {
        return this.dataPreProcessor;
    }

    public ArrayList<ServerListener> getListeners() {
        return this.listeners;
    }

    public ArrayList<IOHandlerListener> getIOListeners() {
        return this.iOListeners;
    }

    public int getSO_TIMEOUT() {
        return this.SO_TIMEOUT;
    }

    public void setSO_TIMEOUT(int SO_TIMEOUT) {
        this.SO_TIMEOUT = SO_TIMEOUT;
    }

    public static boolean isVERBOSE() {
        return VERBOSE;
    }

    public static void setVERBOSE(boolean VERBOSE) {
        Server.VERBOSE = VERBOSE;
    }

    static enum EventType {
        ACCEPT,
        ACCEPT_END,
        ACCEPT_FAILED,
        ACCEPT_START,
        CLOSE,
        CLOSE_END,
        CLOSE_FAILED,
        COMMUNICATIONHANDLER_CLOSE,
        COMMUNICATIONHANDLER_CLOSE_END,
        COMMUNICATIONHANDLER_CLOSE_FAILED,
        COMMUNICATIONHANDLER_INIT_FAILED,
        SOCKET_CLOSED,
        START,
        START_FAILED,
        START_SUCCESS;

    }
}

