/*
 * Decompiled with CFR 0.152.
 */
package dev.bluefalcon;

import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.ParcelUuid;
import dev.bluefalcon.BlueFalconDelegate;
import dev.bluefalcon.BluetoothCharacteristic;
import dev.bluefalcon.BluetoothPeripheral;
import dev.bluefalcon.BluetoothPermissionException;
import dev.bluefalcon.BluetoothService;
import dev.bluefalcon.LogKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0002HIB\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010$\u001a\u00020\u0010J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010,\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0010J$\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00010/2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u0010J\u001e\u00104\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\u0006\u00105\u001a\u00020\u0010J\u001e\u00106\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\u0006\u00107\u001a\u00020\u0010J\u0016\u00108\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(J\"\u00109\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\n\u0010:\u001a\u00060;j\u0002`<J\u0006\u0010=\u001a\u00020\u001fJ(\u0010>\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\u0006\u00105\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@H\u0002J\u0006\u0010A\u001a\u00020\u001fJ-\u0010B\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\u0006\u0010C\u001a\u00020@2\b\u0010D\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010EJ-\u0010B\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\u0006\u0010C\u001a\u00020\u00062\b\u0010D\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010FJ-\u0010G\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020(2\u0006\u0010C\u001a\u00020@2\b\u0010D\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010ER\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006J"}, d2={"Ldev/bluefalcon/BlueFalcon;", "", "context", "Landroid/app/Application;", "Ldev/bluefalcon/ApplicationContext;", "serviceUUID", "", "(Landroid/app/Application;Ljava/lang/String;)V", "bluetoothManager", "Landroid/bluetooth/BluetoothManager;", "delegates", "", "Ldev/bluefalcon/BlueFalconDelegate;", "getDelegates", "()Ljava/util/Set;", "isScanning", "", "()Z", "setScanning", "(Z)V", "mBluetoothScanCallBack", "Ldev/bluefalcon/BlueFalcon$BluetoothScanCallBack;", "mGattClientCallback", "Ldev/bluefalcon/BlueFalcon$GattClientCallback;", "transportMethod", "", "getTransportMethod", "()I", "setTransportMethod", "(I)V", "changeMTU", "", "bluetoothPeripheral", "Ldev/bluefalcon/BluetoothPeripheral;", "mtuSize", "connect", "autoConnect", "disconnect", "fetchCharacteristic", "", "Ldev/bluefalcon/BluetoothCharacteristic;", "bluetoothCharacteristic", "gatt", "Landroid/bluetooth/BluetoothGatt;", "indicateCharacteristic", "indicate", "mapNativeAdvertisementDataToShared", "", "LAdvertisementDataRetrievalKeys;", "receivedScanRecord", "Landroid/bluetooth/le/ScanRecord;", "isConnectable", "notifyAndIndicateCharacteristic", "enable", "notifyCharacteristic", "notify", "readCharacteristic", "readDescriptor", "bluetoothCharacteristicDescriptor", "Landroid/bluetooth/BluetoothGattDescriptor;", "Ldev/bluefalcon/BluetoothCharacteristicDescriptor;", "scan", "setCharacteristicNotification", "descriptorValue", "", "stopScanning", "writeCharacteristic", "value", "writeType", "(Ldev/bluefalcon/BluetoothPeripheral;Ldev/bluefalcon/BluetoothCharacteristic;[BLjava/lang/Integer;)V", "(Ldev/bluefalcon/BluetoothPeripheral;Ldev/bluefalcon/BluetoothCharacteristic;Ljava/lang/String;Ljava/lang/Integer;)V", "writeCharacteristicWithoutEncoding", "BluetoothScanCallBack", "GattClientCallback", "blue-falcon_debug"})
public final class BlueFalcon {
    @NotNull
    private final Application context;
    @Nullable
    private final String serviceUUID;
    @NotNull
    private final Set<BlueFalconDelegate> delegates;
    @NotNull
    private final BluetoothManager bluetoothManager;
    @NotNull
    private final BluetoothScanCallBack mBluetoothScanCallBack;
    @NotNull
    private final GattClientCallback mGattClientCallback;
    private int transportMethod;
    private boolean isScanning;

    public BlueFalcon(@NotNull Application context, @Nullable String serviceUUID) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.serviceUUID = serviceUUID;
        this.delegates = new LinkedHashSet();
        Object object = this.context.getSystemService("bluetooth");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        }
        this.bluetoothManager = (BluetoothManager)object;
        this.mBluetoothScanCallBack = new BluetoothScanCallBack();
        this.mGattClientCallback = new GattClientCallback();
    }

    @NotNull
    public final Set<BlueFalconDelegate> getDelegates() {
        return this.delegates;
    }

    public final int getTransportMethod() {
        return this.transportMethod;
    }

    public final void setTransportMethod(int n) {
        this.transportMethod = n;
    }

    public final boolean isScanning() {
        return this.isScanning;
    }

    public final void setScanning(boolean bl) {
        this.isScanning = bl;
    }

    public final void connect(@NotNull BluetoothPeripheral bluetoothPeripheral, boolean autoConnect) {
        Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
        LogKt.log("connect");
        bluetoothPeripheral.getBluetoothDevice().connectGatt((Context)this.context, autoConnect, (BluetoothGattCallback)this.mGattClientCallback, this.transportMethod);
    }

    public static /* synthetic */ void connect$default(BlueFalcon blueFalcon, BluetoothPeripheral bluetoothPeripheral, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        blueFalcon.connect(bluetoothPeripheral, bl);
    }

    public final void disconnect(@NotNull BluetoothPeripheral bluetoothPeripheral) {
        Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
        LogKt.log("disconnect");
        BluetoothGatt bluetoothGatt = this.mGattClientCallback.gattForDevice(bluetoothPeripheral.getBluetoothDevice());
        if (bluetoothGatt != null) {
            BluetoothGatt bluetoothGatt2;
            BluetoothGatt $this$disconnect_u24lambda_u2d0 = bluetoothGatt2 = bluetoothGatt;
            boolean bl = false;
            $this$disconnect_u24lambda_u2d0.disconnect();
            $this$disconnect_u24lambda_u2d0.close();
        }
        Iterable $this$forEach$iv = this.delegates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
            boolean bl = false;
            it.didDisconnect(bluetoothPeripheral);
        }
    }

    public final void stopScanning() {
        block0: {
            this.isScanning = false;
            BluetoothAdapter bluetoothAdapter = this.bluetoothManager.getAdapter();
            if (bluetoothAdapter == null || (bluetoothAdapter = bluetoothAdapter.getBluetoothLeScanner()) == null) break block0;
            bluetoothAdapter.stopScan((ScanCallback)this.mBluetoothScanCallBack);
        }
    }

    public final void scan() {
        block2: {
            BluetoothLeScanner bluetoothScanner;
            if (this.context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                throw new BluetoothPermissionException(null, 1, null);
            }
            LogKt.log("BT Scan started");
            this.isScanning = true;
            ScanFilter.Builder filterBuilder = new ScanFilter.Builder();
            String string = this.serviceUUID;
            if (string != null) {
                String it = string;
                boolean bl = false;
                filterBuilder.setServiceUuid(new ParcelUuid(UUID.fromString(it)));
            }
            ScanFilter filter = filterBuilder.build();
            List filters = CollectionsKt.listOf((Object)filter);
            ScanSettings settings = new ScanSettings.Builder().setScanMode(0).build();
            BluetoothAdapter bluetoothAdapter = this.bluetoothManager.getAdapter();
            BluetoothLeScanner bluetoothLeScanner = bluetoothScanner = bluetoothAdapter != null ? bluetoothAdapter.getBluetoothLeScanner() : null;
            if (bluetoothLeScanner == null) break block2;
            bluetoothLeScanner.startScan(filters, settings, (ScanCallback)this.mBluetoothScanCallBack);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<BluetoothCharacteristic> fetchCharacteristic(BluetoothCharacteristic bluetoothCharacteristic, BluetoothGatt gatt) {
        void $this$flatMapTo$iv$iv;
        List list = gatt.getServices();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"gatt.services");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BluetoothGattCharacteristic it;
            void $this$filterTo$iv$iv;
            BluetoothGattService service = (BluetoothGattService)element$iv$iv;
            boolean bl = false;
            List list2 = service.getCharacteristics();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"service.characteristics");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it = (BluetoothGattCharacteristic)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)bluetoothCharacteristic.getCharacteristic().getUuid())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BluetoothGattCharacteristic)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(new BluetoothCharacteristic(it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void readCharacteristic(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic) {
        block1: {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
            Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
            BluetoothGatt bluetoothGatt = this.mGattClientCallback.gattForDevice(bluetoothPeripheral.getBluetoothDevice());
            if (bluetoothGatt == null) break block1;
            BluetoothGatt gatt = bluetoothGatt;
            boolean bl = false;
            Iterable iterable = this.fetchCharacteristic(bluetoothCharacteristic, gatt);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothCharacteristic it = (BluetoothCharacteristic)element$iv;
                boolean bl2 = false;
                gatt.readCharacteristic(it.getCharacteristic());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setCharacteristicNotification(BluetoothPeripheral bluetoothPeripheral, BluetoothCharacteristic bluetoothCharacteristic, boolean enable, byte[] descriptorValue) {
        block2: {
            void $this$forEach$iv;
            BluetoothGatt bluetoothGatt = this.mGattClientCallback.gattForDevice(bluetoothPeripheral.getBluetoothDevice());
            if (bluetoothGatt == null) break block2;
            BluetoothGatt gatt = bluetoothGatt;
            boolean bl = false;
            Iterable iterable = this.fetchCharacteristic(bluetoothCharacteristic, gatt);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothCharacteristic it = (BluetoothCharacteristic)element$iv;
                boolean bl2 = false;
                gatt.setCharacteristicNotification(it.getCharacteristic(), enable);
                List list = it.getCharacteristic().getDescriptors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.characteristic.descriptors");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    BluetoothGattDescriptor descriptor = (BluetoothGattDescriptor)element$iv2;
                    boolean bl3 = false;
                    descriptor.setValue(descriptorValue);
                    gatt.writeDescriptor(descriptor);
                }
            }
        }
    }

    public final void notifyCharacteristic(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
        Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
        byte[] byArray = notify ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"if (notify)\n            \u2026ISABLE_NOTIFICATION_VALUE");
        this.setCharacteristicNotification(bluetoothPeripheral, bluetoothCharacteristic, notify, byArray);
    }

    public final void indicateCharacteristic(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic, boolean indicate) {
        Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
        Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
        byte[] byArray = indicate ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"if (indicate)\n          \u2026ISABLE_NOTIFICATION_VALUE");
        this.setCharacteristicNotification(bluetoothPeripheral, bluetoothCharacteristic, indicate, byArray);
    }

    public final void notifyAndIndicateCharacteristic(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic, boolean enable) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
        Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
        if (enable) {
            byte[] byArray2 = new byte[]{3, 0};
            byArray = byArray2;
        } else {
            byArray = BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"if (enable)\n            \u2026ISABLE_NOTIFICATION_VALUE");
        this.setCharacteristicNotification(bluetoothPeripheral, bluetoothCharacteristic, enable, byArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeCharacteristic(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic, @NotNull String value, @Nullable Integer writeType) {
        block2: {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
            Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            BluetoothGatt bluetoothGatt = this.mGattClientCallback.gattForDevice(bluetoothPeripheral.getBluetoothDevice());
            if (bluetoothGatt == null) break block2;
            BluetoothGatt gatt = bluetoothGatt;
            boolean bl = false;
            Iterable iterable = this.fetchCharacteristic(bluetoothCharacteristic, gatt);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothCharacteristic it = (BluetoothCharacteristic)element$iv;
                boolean bl2 = false;
                Integer n = writeType;
                if (n != null) {
                    int writeType2 = ((Number)n).intValue();
                    boolean bl3 = false;
                    it.getCharacteristic().setWriteType(writeType2);
                }
                it.getCharacteristic().setValue(value);
                gatt.writeCharacteristic(it.getCharacteristic());
            }
        }
    }

    public final void writeCharacteristicWithoutEncoding(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic, @NotNull byte[] value, @Nullable Integer writeType) {
        Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
        Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeCharacteristic(bluetoothPeripheral, bluetoothCharacteristic, value, writeType);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeCharacteristic(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic, @NotNull byte[] value, @Nullable Integer writeType) {
        block2: {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
            Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            BluetoothGatt bluetoothGatt = this.mGattClientCallback.gattForDevice(bluetoothPeripheral.getBluetoothDevice());
            if (bluetoothGatt == null) break block2;
            BluetoothGatt gatt = bluetoothGatt;
            boolean bl = false;
            Iterable iterable = this.fetchCharacteristic(bluetoothCharacteristic, gatt);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothCharacteristic it = (BluetoothCharacteristic)element$iv;
                boolean bl2 = false;
                Integer n = writeType;
                if (n != null) {
                    int writeType2 = ((Number)n).intValue();
                    boolean bl3 = false;
                    it.getCharacteristic().setWriteType(writeType2);
                }
                it.getCharacteristic().setValue(value);
                gatt.writeCharacteristic(it.getCharacteristic());
            }
        }
    }

    public final void readDescriptor(@NotNull BluetoothPeripheral bluetoothPeripheral, @NotNull BluetoothCharacteristic bluetoothCharacteristic, @NotNull BluetoothGattDescriptor bluetoothCharacteristicDescriptor) {
        Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
        Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristic, (String)"bluetoothCharacteristic");
        Intrinsics.checkNotNullParameter((Object)bluetoothCharacteristicDescriptor, (String)"bluetoothCharacteristicDescriptor");
        BluetoothGatt bluetoothGatt = this.mGattClientCallback.gattForDevice(bluetoothPeripheral.getBluetoothDevice());
        if (bluetoothGatt != null) {
            bluetoothGatt.readDescriptor(bluetoothCharacteristicDescriptor);
        }
        LogKt.log("readDescriptor -> " + bluetoothCharacteristicDescriptor.getUuid());
    }

    public final void changeMTU(@NotNull BluetoothPeripheral bluetoothPeripheral, int mtuSize) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bluetoothPeripheral, (String)"bluetoothPeripheral");
            BluetoothGatt bluetoothGatt = this.mGattClientCallback.gattForDevice(bluetoothPeripheral.getBluetoothDevice());
            if (bluetoothGatt == null) break block0;
            bluetoothGatt.requestMtu(mtuSize);
        }
    }

    @NotNull
    public final Map<AdvertisementDataRetrievalKeys, Object> mapNativeAdvertisementDataToShared(@Nullable ScanRecord receivedScanRecord, boolean isConnectable) {
        Map sharedAdvertisementData = new LinkedHashMap();
        ScanRecord scanRecord = receivedScanRecord;
        if (scanRecord == null) {
            return sharedAdvertisementData;
        }
        ScanRecord scanRecord2 = scanRecord;
        byte[] advertisementBytes = scanRecord2.getBytes();
        sharedAdvertisementData.put(AdvertisementDataRetrievalKeys.IsConnectable, isConnectable ? 1 : 0);
        int index = 0;
        block5: while (index < advertisementBytes.length) {
            int length = UByte.constructor-impl((byte)advertisementBytes[index]) & 0xFF;
            ++index;
            if (length == 0) break;
            int type = UByte.constructor-impl((byte)advertisementBytes[index]) & 0xFF;
            if (type == 0 || index + length > advertisementBytes.length - 1) break;
            Intrinsics.checkNotNullExpressionValue((Object)advertisementBytes, (String)"advertisementBytes");
            byte[] byArray = advertisementBytes;
            int n = index + 1;
            int n2 = index + length;
            byte[] value = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            switch (type) {
                case 9: {
                    sharedAdvertisementData.put(AdvertisementDataRetrievalKeys.LocalName, new String(value, Charsets.UTF_8));
                    break;
                }
                case 255: {
                    sharedAdvertisementData.put(AdvertisementDataRetrievalKeys.ManufacturerData, value);
                    break;
                }
                case 7: {
                    List uuidAsStringList = new ArrayList();
                    ArraysKt.reverse((byte[])value);
                    int uuidIndex = 0;
                    int uuidLength = 16;
                    while (uuidIndex + uuidLength <= value.length) {
                        byte[] byArray2 = value;
                        int n3 = uuidIndex + uuidLength;
                        byte[] uuidAsBytes = ArraysKt.copyOfRange((byte[])byArray2, (int)uuidIndex, (int)n3);
                        ByteBuffer byteBuffer = ByteBuffer.wrap(uuidAsBytes);
                        long high = byteBuffer.getLong();
                        long low = byteBuffer.getLong();
                        UUID uuid = new UUID(high, low);
                        String string = uuid.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid.toString()");
                        uuidAsStringList.add(string);
                        uuidIndex += uuidLength;
                    }
                    sharedAdvertisementData.put(AdvertisementDataRetrievalKeys.ServiceUUIDsKey, uuidAsStringList);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            index += length;
        }
        return sharedAdvertisementData;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Ldev/bluefalcon/BlueFalcon$BluetoothScanCallBack;", "Landroid/bluetooth/le/ScanCallback;", "(Ldev/bluefalcon/BlueFalcon;)V", "addScanResult", "", "result", "Landroid/bluetooth/le/ScanResult;", "onBatchScanResults", "results", "", "onScanFailed", "errorCode", "", "onScanResult", "callbackType", "blue-falcon_debug"})
    public final class BluetoothScanCallBack
    extends ScanCallback {
        public void onScanResult(int callbackType, @Nullable ScanResult result) {
            this.addScanResult(result);
        }

        public void onBatchScanResults(@Nullable List<ScanResult> results) {
            block1: {
                List<ScanResult> list = results;
                if (list == null) break block1;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ScanResult it = (ScanResult)element$iv;
                    boolean bl = false;
                    this.addScanResult(it);
                }
            }
        }

        public void onScanFailed(int errorCode) {
            LogKt.log("Failed to scan with code " + errorCode);
        }

        private final void addScanResult(ScanResult result) {
            block2: {
                BluetoothDevice bluetoothDevice;
                ScanResult scanResult = result;
                if (scanResult == null) break block2;
                ScanResult scanResult2 = scanResult;
                BlueFalcon blueFalcon = BlueFalcon.this;
                ScanResult scanResult3 = scanResult2;
                boolean bl = false;
                BluetoothDevice bluetoothDevice2 = bluetoothDevice = scanResult3.getDevice();
                if (bluetoothDevice2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice2, (String)"device");
                    BluetoothDevice device = bluetoothDevice;
                    boolean bl2 = false;
                    boolean isConnectable = Build.VERSION.SDK_INT >= 26 ? scanResult3.isConnectable() : false;
                    Map<AdvertisementDataRetrievalKeys, Object> sharedAdvertisementData = blueFalcon.mapNativeAdvertisementDataToShared(scanResult3.getScanRecord(), isConnectable);
                    BluetoothPeripheral bluetoothPeripheral = new BluetoothPeripheral(device);
                    bluetoothPeripheral.setRssi(Float.valueOf(scanResult3.getRssi()));
                    Iterable $this$forEach$iv = blueFalcon.getDelegates();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
                        boolean bl3 = false;
                        it.didDiscoverDevice(bluetoothPeripheral, sharedAdvertisementData);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J$\u0010\u0010\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0014\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J$\u0010\u0016\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0019\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u001b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u001d\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/bluefalcon/BlueFalcon$GattClientCallback;", "Landroid/bluetooth/BluetoothGattCallback;", "(Ldev/bluefalcon/BlueFalcon;)V", "gatts", "", "Landroid/bluetooth/BluetoothGatt;", "addGatt", "", "gatt", "gattForDevice", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "handleCharacteristicValueChange", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "onCharacteristicChanged", "onCharacteristicRead", "status", "", "onCharacteristicWrite", "onConnectionStateChange", "newState", "onDescriptorRead", "descriptor", "Landroid/bluetooth/BluetoothGattDescriptor;", "onMtuChanged", "mtu", "onReadRemoteRssi", "rssi", "onServicesDiscovered", "removeGatt", "blue-falcon_debug"})
    public final class GattClientCallback
    extends BluetoothGattCallback {
        @NotNull
        private final List<BluetoothGatt> gatts = new ArrayList();

        private final void addGatt(BluetoothGatt gatt) {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.gatts;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BluetoothGatt it = (BluetoothGatt)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDevice(), (Object)gatt.getDevice())) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if (v0 == null) {
                this.gatts.add(gatt);
            }
        }

        private final void removeGatt(BluetoothGatt gatt) {
            this.gatts.remove(gatt);
        }

        @Nullable
        public final BluetoothGatt gattForDevice(@NotNull BluetoothDevice bluetoothDevice) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
                Iterable $this$firstOrNull$iv = this.gatts;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BluetoothGatt it = (BluetoothGatt)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDevice(), (Object)bluetoothDevice)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public void onConnectionStateChange(@Nullable BluetoothGatt gatt, int status, int newState) {
            block6: {
                super.onConnectionStateChange(gatt, status, newState);
                LogKt.log("onConnectionStateChange");
                BluetoothGatt bluetoothGatt = gatt;
                if (bluetoothGatt == null) break block6;
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                BlueFalcon blueFalcon = BlueFalcon.this;
                BluetoothGatt bluetoothGatt3 = bluetoothGatt2;
                boolean bl = false;
                BluetoothDevice it = bluetoothGatt3.getDevice();
                boolean bl2 = false;
                switch (newState) {
                    case 2: {
                        this.addGatt(bluetoothGatt3);
                        bluetoothGatt3.readRemoteRssi();
                        bluetoothGatt3.discoverServices();
                        Iterable $this$forEach$iv = blueFalcon.getDelegates();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BlueFalconDelegate it2 = (BlueFalconDelegate)element$iv;
                            boolean bl3 = false;
                            BluetoothDevice bluetoothDevice = bluetoothGatt3.getDevice();
                            Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"bluetoothGatt.device");
                            it2.didConnect(new BluetoothPeripheral(bluetoothDevice));
                        }
                        break;
                    }
                    case 0: {
                        this.removeGatt(bluetoothGatt3);
                        Iterable $this$forEach$iv = blueFalcon.getDelegates();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BlueFalconDelegate it3 = (BlueFalconDelegate)element$iv;
                            boolean bl4 = false;
                            BluetoothDevice bluetoothDevice = bluetoothGatt3.getDevice();
                            Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"bluetoothGatt.device");
                            it3.didDisconnect(new BluetoothPeripheral(bluetoothDevice));
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onServicesDiscovered(@Nullable BluetoothGatt gatt, int status) {
            block3: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LogKt.log("onServicesDiscovered");
                if (status != 0) {
                    return;
                }
                BluetoothGatt bluetoothGatt = gatt;
                if (bluetoothGatt == null || (bluetoothGatt = bluetoothGatt.getDevice()) == null) break block3;
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                BlueFalcon blueFalcon = BlueFalcon.this;
                BluetoothGatt bluetoothDevice = bluetoothGatt2;
                boolean bl = false;
                List services = gatt.getServices();
                boolean bl2 = false;
                LogKt.log("onServicesDiscovered -> " + services);
                BluetoothPeripheral bluetoothPeripheral = new BluetoothPeripheral((BluetoothDevice)bluetoothDevice);
                Intrinsics.checkNotNullExpressionValue((Object)services, (String)"services");
                Iterable iterable = services;
                BluetoothPeripheral bluetoothPeripheral2 = bluetoothPeripheral;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BluetoothGattService bluetoothGattService = (BluetoothGattService)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(new BluetoothService((BluetoothGattService)it));
                }
                bluetoothPeripheral2.setDeviceServices((List)destination$iv$iv);
                Iterable $this$forEach$iv = blueFalcon.getDelegates();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
                    boolean bl4 = false;
                    it.didDiscoverServices(bluetoothPeripheral);
                    it.didDiscoverCharacteristics(bluetoothPeripheral);
                }
            }
        }

        public void onMtuChanged(@Nullable BluetoothGatt gatt, int mtu, int status) {
            block2: {
                super.onMtuChanged(gatt, mtu, status);
                LogKt.log("onMtuChanged" + mtu + " status:" + status);
                if (status != 0) {
                    return;
                }
                BluetoothGatt bluetoothGatt = gatt;
                if (bluetoothGatt == null || (bluetoothGatt = bluetoothGatt.getDevice()) == null) break block2;
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                BlueFalcon blueFalcon = BlueFalcon.this;
                BluetoothGatt bluetoothDevice = bluetoothGatt2;
                boolean bl = false;
                Iterable $this$forEach$iv = blueFalcon.getDelegates();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
                    boolean bl2 = false;
                    it.didUpdateMTU(new BluetoothPeripheral((BluetoothDevice)bluetoothDevice));
                }
            }
        }

        public void onReadRemoteRssi(@Nullable BluetoothGatt gatt, int rssi, int status) {
            block1: {
                LogKt.log("onReadRemoteRssi " + rssi);
                BluetoothGatt bluetoothGatt = gatt;
                if (bluetoothGatt == null || (bluetoothGatt = bluetoothGatt.getDevice()) == null) break block1;
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                BlueFalcon blueFalcon = BlueFalcon.this;
                BluetoothGatt bluetoothDevice = bluetoothGatt2;
                boolean bl = false;
                BluetoothPeripheral bluetoothPeripheral = new BluetoothPeripheral((BluetoothDevice)bluetoothDevice);
                bluetoothPeripheral.setRssi(Float.valueOf(rssi));
                Iterable $this$forEach$iv = blueFalcon.getDelegates();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
                    boolean bl2 = false;
                    it.didRssiUpdate(bluetoothPeripheral);
                }
            }
        }

        public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
            this.handleCharacteristicValueChange(gatt, characteristic);
        }

        public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic) {
            this.handleCharacteristicValueChange(gatt, characteristic);
        }

        public void onDescriptorRead(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattDescriptor descriptor, int status) {
            block2: {
                LogKt.log("onDescriptorRead " + descriptor);
                BluetoothGattDescriptor bluetoothGattDescriptor = descriptor;
                if (bluetoothGattDescriptor == null) break block2;
                BluetoothGattDescriptor bluetoothGattDescriptor2 = bluetoothGattDescriptor;
                BlueFalcon blueFalcon = BlueFalcon.this;
                BluetoothGattDescriptor forcedDescriptor = bluetoothGattDescriptor2;
                boolean bl = false;
                BluetoothGatt bluetoothGatt = gatt;
                if (bluetoothGatt != null && (bluetoothGatt = bluetoothGatt.getDevice()) != null) {
                    BluetoothGatt bluetoothDevice = bluetoothGatt;
                    boolean bl2 = false;
                    LogKt.log("onDescriptorRead value " + forcedDescriptor.getValue());
                    Iterable $this$forEach$iv = blueFalcon.getDelegates();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
                        boolean bl3 = false;
                        it.didReadDescriptor(new BluetoothPeripheral((BluetoothDevice)bluetoothDevice), forcedDescriptor);
                    }
                }
            }
        }

        public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
            block2: {
                BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic;
                if (bluetoothGattCharacteristic == null) break block2;
                BluetoothGattCharacteristic bluetoothGattCharacteristic2 = bluetoothGattCharacteristic;
                BlueFalcon blueFalcon = BlueFalcon.this;
                BluetoothGattCharacteristic forcedCharacteristic = bluetoothGattCharacteristic2;
                boolean bl = false;
                BluetoothCharacteristic characteristic2 = new BluetoothCharacteristic(forcedCharacteristic);
                BluetoothGatt bluetoothGatt = gatt;
                if (bluetoothGatt != null && (bluetoothGatt = bluetoothGatt.getDevice()) != null) {
                    BluetoothGatt bluetoothDevice = bluetoothGatt;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv = blueFalcon.getDelegates();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
                        boolean bl3 = false;
                        it.didWriteCharacteristic(new BluetoothPeripheral((BluetoothDevice)bluetoothDevice), characteristic2, status == 0);
                    }
                }
            }
        }

        private final void handleCharacteristicValueChange(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            block2: {
                BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic;
                if (bluetoothGattCharacteristic == null) break block2;
                BluetoothGattCharacteristic bluetoothGattCharacteristic2 = bluetoothGattCharacteristic;
                BlueFalcon blueFalcon = BlueFalcon.this;
                BluetoothGattCharacteristic forcedCharacteristic = bluetoothGattCharacteristic2;
                boolean bl = false;
                BluetoothCharacteristic characteristic2 = new BluetoothCharacteristic(forcedCharacteristic);
                BluetoothGatt bluetoothGatt = gatt;
                if (bluetoothGatt != null && (bluetoothGatt = bluetoothGatt.getDevice()) != null) {
                    BluetoothGatt bluetoothDevice = bluetoothGatt;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv = blueFalcon.getDelegates();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BlueFalconDelegate it = (BlueFalconDelegate)element$iv;
                        boolean bl3 = false;
                        it.didCharacteristcValueChanged(new BluetoothPeripheral((BluetoothDevice)bluetoothDevice), characteristic2);
                    }
                }
            }
        }
    }
}

