/*
 * Decompiled with CFR 0.152.
 */
package dev.bluefalcon;

import android.bluetooth.BluetoothDevice;
import dev.bluefalcon.BluetoothService;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0011\u0010\u001b\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011\u00a8\u0006\u001d"}, d2={"Ldev/bluefalcon/BluetoothPeripheral;", "", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "(Landroid/bluetooth/BluetoothDevice;)V", "getBluetoothDevice", "()Landroid/bluetooth/BluetoothDevice;", "deviceServices", "", "Ldev/bluefalcon/BluetoothService;", "getDeviceServices", "()Ljava/util/List;", "setDeviceServices", "(Ljava/util/List;)V", "name", "", "getName", "()Ljava/lang/String;", "rssi", "", "getRssi", "()Ljava/lang/Float;", "setRssi", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "services", "getServices", "uuid", "getUuid", "blue-falcon_debug"})
public final class BluetoothPeripheral {
    @NotNull
    private final BluetoothDevice bluetoothDevice;
    @Nullable
    private Float rssi;
    @NotNull
    private List<BluetoothService> deviceServices;

    public BluetoothPeripheral(@NotNull BluetoothDevice bluetoothDevice) {
        Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
        this.bluetoothDevice = bluetoothDevice;
        this.deviceServices = CollectionsKt.emptyList();
    }

    @NotNull
    public final BluetoothDevice getBluetoothDevice() {
        return this.bluetoothDevice;
    }

    @Nullable
    public final String getName() {
        String string = this.bluetoothDevice.getName();
        if (string == null) {
            string = this.bluetoothDevice.getAddress();
        }
        return string;
    }

    @NotNull
    public final List<BluetoothService> getServices() {
        return this.deviceServices;
    }

    @NotNull
    public final String getUuid() {
        String string = this.bluetoothDevice.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bluetoothDevice.address");
        return string;
    }

    @Nullable
    public final Float getRssi() {
        return this.rssi;
    }

    public final void setRssi(@Nullable Float f) {
        this.rssi = f;
    }

    @NotNull
    public final List<BluetoothService> getDeviceServices() {
        return this.deviceServices;
    }

    public final void setDeviceServices(@NotNull List<BluetoothService> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.deviceServices = list;
    }
}

