/*
 * Decompiled with CFR 0.152.
 */
package dev.bodewig.autoserializable.gradle.plugin;

import dev.bodewig.autoserializable.gradle.plugin.AutoSerializableDependencies;
import dev.bodewig.autoserializable.gradle.plugin.task.AutoSerializableClassesTask;
import dev.bodewig.autoserializable.gradle.plugin.task.AutoSerializableJarsTask;
import dev.bodewig.autoserializable.gradle.plugin.task.PreAssembleJarTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public class AutoSerializableClassesGradlePlugin
implements Plugin<Project> {
    public static final String SERIALIZERS_CONFIGURATION_NAME = "autoSerializers";
    public static final String API_DEPENDENCIES_CONFIGURATION_NAME = "autoserializableDeps";
    public static final String TEST_CONFIGURATION_NAME = "autoSerializableTest";

    public static Action<? super ConfigurableFileTree> jarFilter() {
        return files -> files.include(new String[]{"*.jar"});
    }

    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        TaskProvider compileTask = project.getTasks().named("compileJava", JavaCompile.class);
        PreAssembleJarTask preAssembleJarTask = (PreAssembleJarTask)((Object)project.getTasks().maybeCreate("preAssembleJar", PreAssembleJarTask.class));
        preAssembleJarTask.setClassFiles((Provider<Directory>)((JavaCompile)compileTask.get()).getDestinationDirectory());
        preAssembleJarTask.dependsOn(new Object[]{compileTask});
        Configuration serializersConfig = (Configuration)project.getConfigurations().maybeCreate(SERIALIZERS_CONFIGURATION_NAME);
        serializersConfig.defaultDependencies(dependencies -> {
            DirectoryProperty preAssembleJarOutput = preAssembleJarTask.getDestinationDirectory();
            Dependency compiledClasses = project.getDependencies().create((Object)project.fileTree((Object)preAssembleJarOutput, AutoSerializableClassesGradlePlugin.jarFilter()));
            dependencies.add((Object)compiledClasses);
            dependencies.add((Object)AutoSerializableDependencies.autoserializableApi(project));
        });
        Configuration compileClasspathConfig = project.getConfigurations().getByName("compileClasspath");
        serializersConfig.extendsFrom(new Configuration[]{compileClasspathConfig});
        TaskProvider autoSerializableClassesTask = project.getTasks().register("autoSerializableClasses", AutoSerializableClassesTask.class, task -> {
            task.setInPlace((Provider<Directory>)((JavaCompile)compileTask.get()).getDestinationDirectory());
            task.setClassPath((Iterable)serializersConfig);
            task.dependsOn(new Object[]{preAssembleJarTask});
            task.mustRunAfter(new Object[]{project.getTasks().withType(AutoSerializableJarsTask.class)});
        });
        Configuration apiConfig = (Configuration)project.getConfigurations().maybeCreate(API_DEPENDENCIES_CONFIGURATION_NAME);
        apiConfig.defaultDependencies(dependencies -> {
            Dependency autoserializableApi = AutoSerializableDependencies.autoserializableApi(project);
            dependencies.add((Object)autoserializableApi);
        });
        project.getConfigurations().getByName("api", config -> config.extendsFrom(new Configuration[]{apiConfig}));
        Configuration testConfig = (Configuration)project.getConfigurations().maybeCreate(TEST_CONFIGURATION_NAME);
        testConfig.defaultDependencies(dependencies -> dependencies.add((Object)AutoSerializableDependencies.autoserializableJunit(project)));
        project.getConfigurations().getByName("testImplementation", config -> config.extendsFrom(new Configuration[]{testConfig}));
        project.getTasks().named("compileTestJava").configure(task -> task.dependsOn(new Object[]{autoSerializableClassesTask}));
        project.getTasks().named("classes").configure(task -> task.dependsOn(new Object[]{autoSerializableClassesTask}));
    }
}

