/*
 * Decompiled with CFR 0.152.
 */
package dev.bodewig.autoserializable.gradle.plugin;

import dev.bodewig.autoserializable.gradle.plugin.AutoSerializableDependencies;
import dev.bodewig.autoserializable.gradle.plugin.output.AutoSerializableJarsOutput;
import dev.bodewig.autoserializable.gradle.plugin.output.JavaClassesOutput;
import dev.bodewig.autoserializable.gradle.plugin.task.AutoSerializableJarsTask;
import dev.bodewig.autoserializable.gradle.plugin.task.NonPrivateTask;
import dev.bodewig.autoserializable.gradle.plugin.task.PreAssembleJarTask;
import dev.bodewig.autoserializable.gradle.plugin.task.PullJarsTask;
import net.bytebuddy.build.gradle.ByteBuddyJarsTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public class AutoSerializableJarsGradlePlugin
implements Plugin<Project> {
    public static final String AUTO_SERIALIZABLE_CONFIGURATION_NAME = "autoSerializable";
    public static final String NON_PRIVATE_CONFIGURATION_NAME = "nonPrivateConfig";
    public static final String SERIALIZERS_CONFIGURATION_NAME = "autoSerializers";
    public static final String API_DEPENDENCIES_CONFIGURATION_NAME = "autoserializableDeps";
    public static final String TEST_CONFIGURATION_NAME = "autoSerializableTest";

    public static Action<? super ConfigurableFileTree> jarFilter() {
        return files -> files.include(new String[]{"*.jar"});
    }

    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        JavaClassesOutput javaClassesOutput = project.getExtensions().findByType(JavaClassesOutput.class) != null ? (JavaClassesOutput)project.getExtensions().getByType(JavaClassesOutput.class) : (JavaClassesOutput)project.getExtensions().create("JavaClassesOutput", JavaClassesOutput.class, new Object[0]);
        AutoSerializableJarsOutput autoSerializableJarsOutput = (AutoSerializableJarsOutput)project.getExtensions().create("AutoSerializableJarsOutput", AutoSerializableJarsOutput.class, new Object[0]);
        Configuration autoSerializableConfig = (Configuration)project.getConfigurations().maybeCreate(AUTO_SERIALIZABLE_CONFIGURATION_NAME);
        TaskProvider pullJarsTask = project.getTasks().register("pullJars", PullJarsTask.class, task -> task.setConfiguration(autoSerializableConfig));
        TaskProvider nonPrivateTask = project.getTasks().register("byteBuddyNonPrivate", NonPrivateTask.class, task -> {
            task.setSource(((Directory)((Provider)pullJarsTask.map(PullJarsTask::getPulledDir).get()).get()).getAsFile());
            task.setClassPath((Iterable)autoSerializableConfig);
            task.dependsOn(new Object[]{pullJarsTask});
        });
        Configuration nonPrivateConfig = (Configuration)project.getConfigurations().maybeCreate(NON_PRIVATE_CONFIGURATION_NAME);
        nonPrivateConfig.defaultDependencies(dependencies -> {
            Provider nonPrivateOutput = nonPrivateTask.map(ByteBuddyJarsTask::getTarget);
            Dependency nonPrivateJars = project.getDependencies().create((Object)project.fileTree((Object)nonPrivateOutput, AutoSerializableJarsGradlePlugin.jarFilter()));
            dependencies.add((Object)nonPrivateJars);
        });
        Configuration compileClasspathConfig = project.getConfigurations().getByName("compileClasspath");
        compileClasspathConfig.extendsFrom(new Configuration[]{nonPrivateConfig});
        TaskProvider compileTask = project.getTasks().named("compileJava", JavaCompile.class);
        compileTask.configure(task -> {
            task.dependsOn(new Object[]{nonPrivateTask});
            task.doLast(t -> javaClassesOutput.getClassFiles().addAll((Iterable)t.getOutputs().getFiles().getAsFileTree()));
        });
        TaskProvider preAssembleJarTask = project.getTasks().register("preAssembleJar", PreAssembleJarTask.class, task -> {
            task.setClassFiles((Provider<Directory>)((JavaCompile)compileTask.get()).getDestinationDirectory());
            task.dependsOn(new Object[]{compileTask});
        });
        Configuration serializersConfig = (Configuration)project.getConfigurations().maybeCreate(SERIALIZERS_CONFIGURATION_NAME);
        serializersConfig.defaultDependencies(dependencies -> {
            DirectoryProperty preAssembleJarOutput = ((PreAssembleJarTask)((Object)((Object)preAssembleJarTask.get()))).getDestinationDirectory();
            Dependency compiledClasses = project.getDependencies().create((Object)project.fileTree((Object)preAssembleJarOutput, AutoSerializableJarsGradlePlugin.jarFilter()));
            dependencies.add((Object)compiledClasses);
            dependencies.add((Object)AutoSerializableDependencies.autoserializableApi(project));
        });
        serializersConfig.extendsFrom(new Configuration[]{compileClasspathConfig});
        TaskProvider autoSerializableJarsTask = project.getTasks().register("autoSerializableJars", AutoSerializableJarsTask.class, task -> {
            Directory pulledDir = (Directory)((Provider)pullJarsTask.map(PullJarsTask::getPulledDir).get()).get();
            task.setSource(pulledDir.getAsFile());
            task.setClassPath((Iterable)serializersConfig);
            task.dependsOn(new Object[]{preAssembleJarTask});
            autoSerializableJarsOutput.getJarFiles().addAll((Iterable)pulledDir.getAsFileTree().getFiles());
        });
        Configuration apiConfig = (Configuration)project.getConfigurations().maybeCreate(API_DEPENDENCIES_CONFIGURATION_NAME);
        apiConfig.defaultDependencies(dependencies -> {
            Dependency autoserializableApi = AutoSerializableDependencies.autoserializableApi(project);
            dependencies.add((Object)autoserializableApi);
            Provider autoSerializableOutput = autoSerializableJarsTask.map(ByteBuddyJarsTask::getTarget);
            Dependency transformedDir = project.getDependencies().create((Object)project.fileTree((Object)autoSerializableOutput, AutoSerializableJarsGradlePlugin.jarFilter()));
            dependencies.add((Object)transformedDir);
        });
        project.getConfigurations().getByName("api", config -> config.extendsFrom(new Configuration[]{apiConfig}));
        Configuration testConfig = (Configuration)project.getConfigurations().maybeCreate(TEST_CONFIGURATION_NAME);
        testConfig.defaultDependencies(dependencies -> {
            dependencies.add((Object)AutoSerializableDependencies.autoserializableJunit(project));
            Provider autoSerializableOutput = autoSerializableJarsTask.map(ByteBuddyJarsTask::getTarget);
            Dependency transformedDir = project.getDependencies().create((Object)project.fileTree((Object)autoSerializableOutput, AutoSerializableJarsGradlePlugin.jarFilter()));
            dependencies.add((Object)transformedDir);
        });
        project.getConfigurations().getByName("testImplementation", config -> config.extendsFrom(new Configuration[]{testConfig}));
        project.getTasks().named("compileTestJava").configure(task -> task.dependsOn(new Object[]{autoSerializableJarsTask}));
        project.getTasks().named("classes").configure(task -> task.dependsOn(new Object[]{autoSerializableJarsTask}));
    }
}

