/*
 * Decompiled with CFR 0.152.
 */
package dev.bodewig.autoserializable.junit;

import dev.bodewig.autoserializable.api.AutoSerializable;
import dev.bodewig.autoserializable.api.AutoSerializableAll;
import dev.bodewig.autoserializable.api.AutoSerialized;
import dev.bodewig.autoserializable.api.AutoSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.commons.util.ReflectionUtils;

public class AutoSerializableTestFactory {
    protected List<Class<?>> classes;
    protected List<Class<?>> serializers;
    protected List<DynamicTest> tests;

    public AutoSerializableTestFactory(URI ... sources) {
        this(List.of(sources));
    }

    public AutoSerializableTestFactory(Collection<URI> sources) {
        this.classes = this.findClasses(sources);
        this.serializers = this.findSerializers(sources);
        this.tests = List.of();
    }

    private AutoSerializableTestFactory(List<Class<?>> classes, List<Class<?>> serializers, List<DynamicTest> tests) {
        this.classes = classes;
        this.serializers = serializers;
        this.tests = tests;
    }

    protected static Function<Class<?>, String> nameGenerator(String method) {
        return clazz -> method + "_" + clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    public static Stream<DynamicTest> testSerialization(Object ... instances) {
        return AutoSerializableTestFactory.testSerialization(List.of(instances));
    }

    public static Stream<DynamicTest> testSerialization(Collection<Object> instances) {
        return DynamicTest.stream(instances.stream(), instance -> "testSerialization_" + instance.getClass().getSimpleName(), AutoSerializableTestFactory::testSerialization);
    }

    public static void testSerialization(Object instance) {
        Assertions.assertDoesNotThrow(() -> {
            byte[] data;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(instance);
                data = baos.toByteArray();
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);
                 ObjectInputStream ois = new ObjectInputStream(bais);){
                ois.readObject();
            }
        }, (String)("testSerialization failed on " + Optional.ofNullable(instance.getClass().getCanonicalName()).orElse("(anonymous class)")));
    }

    private AutoSerializableTestFactory test(Stream<Class<?>> inputStream, String testName, ThrowingConsumer<Class<?>> testExecutor) {
        return new AutoSerializableTestFactory(this.classes, this.serializers, Stream.concat(this.tests.stream(), DynamicTest.stream(inputStream, AutoSerializableTestFactory.nameGenerator(testName), clazz -> Assertions.assertDoesNotThrow(() -> testExecutor.accept(clazz), (String)(testName + " failed on " + Optional.ofNullable(clazz.getCanonicalName()).orElse("(anonymous class)"))))).toList());
    }

    protected List<Class<?>> findClasses(Collection<URI> uris) {
        return uris.stream().flatMap(uri -> ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, x -> true, x -> true).stream()).distinct().toList();
    }

    protected List<Class<?>> findSerializers(Collection<URI> uris) {
        return uris.stream().flatMap(uri -> ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, (ClassFilter)ClassFilter.of(clazz -> clazz.isAnnotationPresent(AutoSerializable.class) || clazz.isAnnotationPresent(AutoSerializableAll.class) || AutoSerializer.class.isAssignableFrom((Class<?>)clazz))).stream()).distinct().toList();
    }

    public Stream<DynamicTest> build() {
        return this.tests.stream();
    }

    public AutoSerializableTestFactory testAllClassesImplementSerializable() {
        return this.test(this.classes.stream().filter(clazz -> !clazz.isAnnotation() && !this.serializers.contains(clazz)), "testAllClassesImplementSerializable", clazz -> Assertions.assertTrue((boolean)Serializable.class.isAssignableFrom((Class<?>)clazz), (String)(clazz.getCanonicalName() + " does not implement " + Serializable.class.getCanonicalName())));
    }

    public AutoSerializableTestFactory testSerializersAnnotated() {
        return this.test(this.serializers.stream(), "testSerializersAnnotated", serializer -> Assertions.assertTrue((boolean)AutoSerializer.class.isAssignableFrom((Class<?>)serializer), (String)("Class " + serializer.getCanonicalName() + " is annotated with " + AutoSerializable.class.getCanonicalName() + " but does not extend " + String.valueOf(AutoSerializer.class))));
    }

    public AutoSerializableTestFactory testSerializersExtend() {
        return this.test(this.serializers.stream(), "testSerializersExtend", serializer -> Assertions.assertTrue((serializer.isAnnotationPresent(AutoSerializable.class) || serializer.isAnnotationPresent(AutoSerializableAll.class) ? 1 : 0) != 0, (String)("Class " + serializer.getCanonicalName() + " extends " + AutoSerializer.class.getCanonicalName() + " but is not annotated with " + String.valueOf(AutoSerializable.class))));
    }

    public AutoSerializableTestFactory testSerializersUsed() {
        return this.test(this.serializers.stream(), "testSerializersUsed", serializer -> Assertions.assertFalse((boolean)AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)serializer, AutoSerializable.class).stream().map(AutoSerializable::value).noneMatch(this.classes::contains), (String)("AutoSerializer " + serializer.getCanonicalName() + " is annotated with " + AutoSerializable.class.getCanonicalName() + " but does not target any class in the provided test scope")));
    }

    public AutoSerializableTestFactory testAutoSerializablesInitialized() {
        return this.test(this.classes.stream().filter(clazz -> !clazz.isAnnotation() && !clazz.isInterface() && !this.serializers.contains(clazz)).filter(clazz -> {
            try {
                clazz.getDeclaredField("_serializer");
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            return true;
        }), "testAutoSerializablesInitialized", clazz -> {
            Field field = clazz.getDeclaredField("_serializer");
            field.setAccessible(true);
            Assertions.assertNotNull((Object)field.get(null), (String)("Generated constant '_serializer' of " + clazz.getCanonicalName() + " was not initialized. The byte code is defect."));
        });
    }

    public AutoSerializableTestFactory testAnnotatedAutoSerialized() {
        return this.test(this.classes.stream().filter(clazz -> !clazz.isAnnotation() && !this.serializers.contains(clazz)), "testAnnotatedAutoSerialized", clazz -> Assertions.assertTrue((boolean)clazz.isAnnotationPresent(AutoSerialized.class), (String)("Type " + clazz.getCanonicalName() + " was not annotated with " + AutoSerialized.class.getCanonicalName())));
    }
}

