/*
 * Decompiled with CFR 0.152.
 */
package dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot;

import dev.bpmcrafters.processengineapi.adapter.c7.remote.correlation.CorrelationApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.correlation.SignalApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.deploy.DeploymentApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.process.StartProcessApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterAutoConfiguration;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterAutoConfigurationKt;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterEnabledCondition;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterProperties;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.C7RemoteTaskSubscriptionApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.completion.C7RemoteServiceUserTaskCompletionApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.completion.FailureRetrySupplier;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.completion.LinearMemoryFailureRetrySupplier;
import dev.bpmcrafters.processengineapi.correlation.CorrelationApi;
import dev.bpmcrafters.processengineapi.correlation.SignalApi;
import dev.bpmcrafters.processengineapi.deploy.DeploymentApi;
import dev.bpmcrafters.processengineapi.impl.task.InMemSubscriptionRepository;
import dev.bpmcrafters.processengineapi.impl.task.SubscriptionRepository;
import dev.bpmcrafters.processengineapi.process.StartProcessApi;
import dev.bpmcrafters.processengineapi.task.TaskSubscriptionApi;
import dev.bpmcrafters.processengineapi.task.UserTaskCompletionApi;
import io.toolisticon.spring.condition.ConditionalOnMissingQualifiedBean;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.community.rest.EnableCamundaRestClient;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={C7RemoteAdapterProperties.class})
@Conditional(value={C7RemoteAdapterEnabledCondition.class})
@EnableCamundaRestClient
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017J\u0012\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001a\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u001f\u001a\u00020\u0012H\u0017\u00a8\u0006 "}, d2={"Ldev/bpmcrafters/processengineapi/adapter/c7/remote/springboot/C7RemoteAdapterAutoConfiguration;", "", "()V", "correlationApi", "Ldev/bpmcrafters/processengineapi/correlation/CorrelationApi;", "runtimeService", "Lorg/camunda/bpm/engine/RuntimeService;", "defaultFailureRetrySupplier", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/task/completion/FailureRetrySupplier;", "c7AdapterProperties", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/springboot/C7RemoteAdapterProperties;", "deployApi", "Ldev/bpmcrafters/processengineapi/deploy/DeploymentApi;", "repositoryService", "Lorg/camunda/bpm/engine/RepositoryService;", "report", "", "serviceTaskWorkerExecutor", "Ljava/util/concurrent/ExecutorService;", "signalApi", "Ldev/bpmcrafters/processengineapi/correlation/SignalApi;", "startProcessApi", "Ldev/bpmcrafters/processengineapi/process/StartProcessApi;", "subscriptionRepository", "Ldev/bpmcrafters/processengineapi/impl/task/SubscriptionRepository;", "taskSubscriptionApi", "Ldev/bpmcrafters/processengineapi/task/TaskSubscriptionApi;", "userTaskCompletionApi", "Ldev/bpmcrafters/processengineapi/task/UserTaskCompletionApi;", "taskService", "Lorg/camunda/bpm/engine/TaskService;", "userTaskWorkerExecutor", "process-engine-api-adapter-camunda-platform-c7-remote-spring-boot-starter"})
public class C7RemoteAdapterAutoConfiguration {
    @PostConstruct
    public void report() {
        C7RemoteAdapterAutoConfigurationKt.access$getLogger$p().debug((Function0)report.1.INSTANCE);
    }

    @Bean(value={"c7remote-task-subscription-api"})
    @Qualifier(value="c7remote-task-subscription-api")
    @NotNull
    public TaskSubscriptionApi taskSubscriptionApi(@NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        return (TaskSubscriptionApi)new C7RemoteTaskSubscriptionApiImpl(subscriptionRepository);
    }

    @Bean(value={"c7remote-start-process-api"})
    @Qualifier(value="c7remote-start-process-api")
    @NotNull
    public StartProcessApi startProcessApi(@Qualifier(value="remote") @NotNull RuntimeService runtimeService) {
        Intrinsics.checkNotNullParameter((Object)runtimeService, (String)"runtimeService");
        return (StartProcessApi)new StartProcessApiImpl(runtimeService);
    }

    @Bean(value={"c7remote-correlation-api"})
    @Qualifier(value="c7remote-correlation-api")
    @NotNull
    public CorrelationApi correlationApi(@Qualifier(value="remote") @NotNull RuntimeService runtimeService) {
        Intrinsics.checkNotNullParameter((Object)runtimeService, (String)"runtimeService");
        return (CorrelationApi)new CorrelationApiImpl(runtimeService);
    }

    @Bean(value={"c7remote-signal-api"})
    @Qualifier(value="c7remote-signal-api")
    @NotNull
    public SignalApi signalApi(@Qualifier(value="remote") @NotNull RuntimeService runtimeService) {
        Intrinsics.checkNotNullParameter((Object)runtimeService, (String)"runtimeService");
        return (SignalApi)new SignalApiImpl(runtimeService);
    }

    @Bean(value={"c7remote-deploy-api"})
    @Qualifier(value="c7remote-deploy-api")
    @NotNull
    public DeploymentApi deployApi(@Qualifier(value="remote") @NotNull RepositoryService repositoryService) {
        Intrinsics.checkNotNullParameter((Object)repositoryService, (String)"repositoryService");
        return (DeploymentApi)new DeploymentApiImpl(repositoryService);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SubscriptionRepository subscriptionRepository() {
        return (SubscriptionRepository)new InMemSubscriptionRepository();
    }

    @Bean(value={"c7remote-service-task-worker-executor"})
    @Qualifier(value="c7remote-service-task-worker-executor")
    @ConditionalOnMissingQualifiedBean(beanClass=ExecutorService.class, qualifier="c7remote-service-task-worker-executor")
    @NotNull
    public ExecutorService serviceTaskWorkerExecutor() {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        return executorService;
    }

    @Bean(value={"c7remote-user-task-worker-executor"})
    @Qualifier(value="c7remote-user-task-worker-executor")
    @ConditionalOnMissingQualifiedBean(beanClass=ExecutorService.class, qualifier="c7remote-user-task-worker-executor")
    @NotNull
    public ExecutorService userTaskWorkerExecutor() {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        return executorService;
    }

    @Bean(value={"c7remote-user-task-completion-api"})
    @Qualifier(value="c7remote-user-task-completion-api")
    @NotNull
    public UserTaskCompletionApi userTaskCompletionApi(@Qualifier(value="remote") @NotNull TaskService taskService, @NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)taskService, (String)"taskService");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        return (UserTaskCompletionApi)new C7RemoteServiceUserTaskCompletionApiImpl(taskService, subscriptionRepository);
    }

    @Bean(value={"c7remote-failure-retry-supplier"})
    @Qualifier(value="c7remote-failure-retry-supplier")
    @ConditionalOnMissingBean
    @NotNull
    public FailureRetrySupplier defaultFailureRetrySupplier(@NotNull C7RemoteAdapterProperties c7AdapterProperties) {
        Intrinsics.checkNotNullParameter((Object)c7AdapterProperties, (String)"c7AdapterProperties");
        return (FailureRetrySupplier)new LinearMemoryFailureRetrySupplier(c7AdapterProperties.getServiceTasks().getRetries(), c7AdapterProperties.getServiceTasks().getRetryTimeoutInSeconds());
    }
}

