/*
 * Decompiled with CFR 0.152.
 */
package dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.client;

import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterAutoConfiguration;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterProperties;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.ConditionalOnServiceTaskDeliveryStrategy;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.client.C7RemoteClientServiceTaskAutoConfiguration;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.client.C7RemoteClientServiceTaskAutoConfigurationKt;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.completion.C7RemoteClientServiceTaskCompletionApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.completion.FailureRetrySupplier;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.delivery.subscribe.SubscribingClientServiceTaskDelivery;
import dev.bpmcrafters.processengineapi.impl.task.SubscriptionRepository;
import dev.bpmcrafters.processengineapi.task.ServiceTaskCompletionApi;
import jakarta.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.impl.ExternalTaskClientImpl;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.client.task.impl.ExternalTaskServiceImpl;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={C7RemoteAdapterAutoConfiguration.class})
@ConditionalOnServiceTaskDeliveryStrategy(strategy=C7RemoteAdapterProperties.ExternalServiceTaskDeliveryStrategy.REMOTE_SUBSCRIBED)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017\u00a8\u0006\u0014"}, d2={"Ldev/bpmcrafters/processengineapi/adapter/c7/remote/springboot/client/C7RemoteClientServiceTaskAutoConfiguration;", "", "()V", "externalTaskClientCompletionApi", "Ldev/bpmcrafters/processengineapi/task/ServiceTaskCompletionApi;", "externalTaskService", "Lorg/camunda/bpm/client/task/ExternalTaskService;", "subscriptionRepository", "Ldev/bpmcrafters/processengineapi/impl/task/SubscriptionRepository;", "failureRetrySupplier", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/task/completion/FailureRetrySupplier;", "externalTaskClientExternalTaskService", "externalTaskClient", "Lorg/camunda/bpm/client/ExternalTaskClient;", "report", "", "subscribingClientExternalTaskDelivery", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/task/delivery/subscribe/SubscribingClientServiceTaskDelivery;", "c7AdapterProperties", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/springboot/C7RemoteAdapterProperties;", "process-engine-api-adapter-camunda-platform-c7-remote-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nC7RemoteClientServiceTaskAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 C7RemoteClientServiceTaskAutoConfiguration.kt\ndev/bpmcrafters/processengineapi/adapter/c7/remote/springboot/client/C7RemoteClientServiceTaskAutoConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public class C7RemoteClientServiceTaskAutoConfiguration {
    @PostConstruct
    public void report() {
        C7RemoteClientServiceTaskAutoConfigurationKt.access$getLogger$p().debug((Function0)report.1.INSTANCE);
    }

    @Bean
    @NotNull
    public ExternalTaskService externalTaskClientExternalTaskService(@NotNull ExternalTaskClient externalTaskClient) {
        Intrinsics.checkNotNullParameter((Object)externalTaskClient, (String)"externalTaskClient");
        if (!(externalTaskClient instanceof ExternalTaskClientImpl)) {
            boolean bl = false;
            String string = "External task client must be official Camunda External Task Client";
            throw new IllegalArgumentException(string.toString());
        }
        return (ExternalTaskService)new ExternalTaskServiceImpl(((ExternalTaskClientImpl)externalTaskClient).getTopicSubscriptionManager().getEngineClient());
    }

    @Bean(name={"c7remote-service-task-delivery"}, initMethod="subscribe", destroyMethod="unsubscribe")
    @NotNull
    public SubscribingClientServiceTaskDelivery subscribingClientExternalTaskDelivery(@NotNull SubscriptionRepository subscriptionRepository, @NotNull ExternalTaskClient externalTaskClient, @NotNull C7RemoteAdapterProperties c7AdapterProperties) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        Intrinsics.checkNotNullParameter((Object)externalTaskClient, (String)"externalTaskClient");
        Intrinsics.checkNotNullParameter((Object)c7AdapterProperties, (String)"c7AdapterProperties");
        long l = c7AdapterProperties.getServiceTasks().getLockTimeInSeconds();
        long l2 = c7AdapterProperties.getServiceTasks().getRetryTimeoutInSeconds();
        int n = c7AdapterProperties.getServiceTasks().getRetries();
        return new SubscribingClientServiceTaskDelivery(externalTaskClient, subscriptionRepository, l, l2, n);
    }

    @Bean(value={"c7remote-service-task-completion-api"})
    @Qualifier(value="c7remote-service-task-completion-api")
    @NotNull
    public ServiceTaskCompletionApi externalTaskClientCompletionApi(@NotNull ExternalTaskService externalTaskService, @NotNull SubscriptionRepository subscriptionRepository, @Qualifier(value="c7remote-failure-retry-supplier") @NotNull FailureRetrySupplier failureRetrySupplier) {
        Intrinsics.checkNotNullParameter((Object)externalTaskService, (String)"externalTaskService");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        Intrinsics.checkNotNullParameter((Object)failureRetrySupplier, (String)"failureRetrySupplier");
        return (ServiceTaskCompletionApi)new C7RemoteClientServiceTaskCompletionApiImpl(externalTaskService, subscriptionRepository, failureRetrySupplier);
    }
}

