/*
 * Decompiled with CFR 0.152.
 */
package dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.schedule;

import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterAutoConfiguration;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterEnabledCondition;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.C7RemoteAdapterProperties;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.ConditionalOnServiceTaskDeliveryStrategy;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.ConditionalOnUserTaskDeliveryStrategy;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.schedule.C7RemoteSchedulingAutoConfiguration;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.springboot.schedule.C7RemoteSchedulingAutoConfigurationKt;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.completion.C7RemoteServiceServiceTaskCompletionApiImpl;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.completion.FailureRetrySupplier;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.delivery.pull.RemotePullServiceTaskDelivery;
import dev.bpmcrafters.processengineapi.adapter.c7.remote.task.delivery.pull.RemotePullUserTaskDelivery;
import dev.bpmcrafters.processengineapi.impl.task.SubscriptionRepository;
import dev.bpmcrafters.processengineapi.task.ServiceTaskCompletionApi;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.TaskService;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableScheduling
@EnableAsync
@AutoConfigureAfter(value={C7RemoteAdapterAutoConfiguration.class})
@Conditional(value={C7RemoteAdapterEnabledCondition.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J,\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J,\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0017J6\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017\u00a8\u0006\u001b"}, d2={"Ldev/bpmcrafters/processengineapi/adapter/c7/remote/springboot/schedule/C7RemoteSchedulingAutoConfiguration;", "", "()V", "report", "", "scheduledServiceTaskDelivery", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/task/delivery/pull/RemotePullServiceTaskDelivery;", "externalTaskService", "Lorg/camunda/bpm/engine/ExternalTaskService;", "subscriptionRepository", "Ldev/bpmcrafters/processengineapi/impl/task/SubscriptionRepository;", "c7AdapterProperties", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/springboot/C7RemoteAdapterProperties;", "executorService", "Ljava/util/concurrent/ExecutorService;", "serviceTaskCompletionApi", "Ldev/bpmcrafters/processengineapi/task/ServiceTaskCompletionApi;", "failureRetrySupplier", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/task/completion/FailureRetrySupplier;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "userTaskDelivery", "Ldev/bpmcrafters/processengineapi/adapter/c7/remote/task/delivery/pull/RemotePullUserTaskDelivery;", "taskService", "Lorg/camunda/bpm/engine/TaskService;", "repositoryService", "Lorg/camunda/bpm/engine/RepositoryService;", "process-engine-api-adapter-camunda-platform-c7-remote-spring-boot-starter"})
public class C7RemoteSchedulingAutoConfiguration {
    @PostConstruct
    public void report() {
        C7RemoteSchedulingAutoConfigurationKt.access$getLogger$p().debug((Function0)report.1.INSTANCE);
    }

    @Bean(value={"c7remote-task-scheduler"})
    @Qualifier(value="c7remote-task-scheduler")
    @ConditionalOnMissingBean
    @NotNull
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(2);
        threadPoolTaskScheduler.setThreadNamePrefix("C7REMOTE-SCHEDULER-");
        return (TaskScheduler)threadPoolTaskScheduler;
    }

    @Bean(value={"c7remote-service-task-delivery"})
    @Qualifier(value="c7remote-service-task-delivery")
    @ConditionalOnServiceTaskDeliveryStrategy(strategy=C7RemoteAdapterProperties.ExternalServiceTaskDeliveryStrategy.REMOTE_SCHEDULED)
    @NotNull
    public RemotePullServiceTaskDelivery scheduledServiceTaskDelivery(@Qualifier(value="remote") @NotNull ExternalTaskService externalTaskService, @NotNull SubscriptionRepository subscriptionRepository, @NotNull C7RemoteAdapterProperties c7AdapterProperties, @Qualifier(value="c7remote-service-task-worker-executor") @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)externalTaskService, (String)"externalTaskService");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        Intrinsics.checkNotNullParameter((Object)c7AdapterProperties, (String)"c7AdapterProperties");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        String string = c7AdapterProperties.getServiceTasks().getWorkerId();
        int n = c7AdapterProperties.getServiceTasks().getMaxTaskCount();
        long l = c7AdapterProperties.getServiceTasks().getLockTimeInSeconds();
        long l2 = c7AdapterProperties.getServiceTasks().getRetryTimeoutInSeconds();
        int n2 = c7AdapterProperties.getServiceTasks().getRetries();
        return new RemotePullServiceTaskDelivery(externalTaskService, string, subscriptionRepository, n, l, l2, n2, executorService);
    }

    @Bean(value={"c7remote-service-task-completion-api"})
    @Qualifier(value="c7remote-service-task-completion-api")
    @ConditionalOnServiceTaskDeliveryStrategy(strategy=C7RemoteAdapterProperties.ExternalServiceTaskDeliveryStrategy.REMOTE_SCHEDULED)
    @NotNull
    public ServiceTaskCompletionApi serviceTaskCompletionApi(@Qualifier(value="remote") @NotNull ExternalTaskService externalTaskService, @NotNull SubscriptionRepository subscriptionRepository, @NotNull C7RemoteAdapterProperties c7AdapterProperties, @Qualifier(value="c7remote-failure-retry-supplier") @NotNull FailureRetrySupplier failureRetrySupplier) {
        Intrinsics.checkNotNullParameter((Object)externalTaskService, (String)"externalTaskService");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        Intrinsics.checkNotNullParameter((Object)c7AdapterProperties, (String)"c7AdapterProperties");
        Intrinsics.checkNotNullParameter((Object)failureRetrySupplier, (String)"failureRetrySupplier");
        return (ServiceTaskCompletionApi)new C7RemoteServiceServiceTaskCompletionApiImpl(c7AdapterProperties.getServiceTasks().getWorkerId(), externalTaskService, subscriptionRepository, failureRetrySupplier);
    }

    @Bean(value={"c7remote-user-task-delivery"})
    @Qualifier(value="c7remote-user-task-delivery")
    @ConditionalOnUserTaskDeliveryStrategy(strategy=C7RemoteAdapterProperties.UserTaskDeliveryStrategy.REMOTE_SCHEDULED)
    @NotNull
    public RemotePullUserTaskDelivery userTaskDelivery(@Qualifier(value="remote") @NotNull TaskService taskService, @NotNull SubscriptionRepository subscriptionRepository, @NotNull C7RemoteAdapterProperties c7AdapterProperties, @Qualifier(value="remote") @NotNull RepositoryService repositoryService, @Qualifier(value="c7remote-user-task-worker-executor") @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)taskService, (String)"taskService");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        Intrinsics.checkNotNullParameter((Object)c7AdapterProperties, (String)"c7AdapterProperties");
        Intrinsics.checkNotNullParameter((Object)repositoryService, (String)"repositoryService");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        return new RemotePullUserTaskDelivery(taskService, repositoryService, subscriptionRepository, executorService);
    }
}

