/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashBuilder;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.Objects;

public class AverageHash
extends HashingAlgorithm {
    private static final long serialVersionUID = -5234612717498362659L;
    protected int height;
    protected int width;

    public AverageHash(int bitResolution) {
        super(bitResolution);
        this.computeDimension(bitResolution);
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        FastPixel fp = this.createPixelAccessor(image, this.width, this.height);
        int[][] luminocity = fp.getLuma();
        double avgPixelValue = ArrayUtil.average((int[][])luminocity);
        return this.computeHash(hash, luminocity, avgPixelValue);
    }

    protected BigInteger computeHash(HashBuilder hash, double[][] pixelValue, double compareAgainst) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (pixelValue[x][y] < compareAgainst) {
                    hash.prependZero();
                    continue;
                }
                hash.prependOne();
            }
        }
        return hash.toBigInteger();
    }

    protected BigInteger computeHash(HashBuilder hash, int[][] pixelValue, double compareAgainst) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if ((double)pixelValue[x][y] < compareAgainst) {
                    hash.prependZero();
                    continue;
                }
                hash.prependOne();
            }
        }
        return hash.toBigInteger();
    }

    private void computeDimension(int bitResolution) {
        int dimension = (int)Math.round(Math.sqrt(bitResolution));
        int normalBound = dimension * dimension;
        int higherBound = dimension * (dimension + 1);
        this.height = dimension;
        this.width = dimension;
        if (normalBound < bitResolution || normalBound - bitResolution > higherBound - bitResolution) {
            ++this.width;
        }
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash("com.github.kilianB.hashAlgorithms." + this.getClass().getSimpleName(), this.height, this.width);
    }
}

