/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.Require;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.AverageHash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashBuilder;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.Kernel;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AverageKernelHash
extends AverageHash {
    private static final long serialVersionUID = -5234612717498362659L;
    private final List<Kernel> filters;

    public AverageKernelHash(int bitResolution) {
        this(bitResolution, Kernel.boxFilterNormalized(3, 3));
    }

    public AverageKernelHash(int bitResolution, Kernel ... kernels) {
        super(bitResolution);
        this.filters = new ArrayList<Kernel>(Arrays.asList((Kernel[])Require.deepNonNull((Object[])kernels, (String)"The kernel may not be null")));
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        FastPixel fp = this.createPixelAccessor(image, this.width, this.height);
        int[][] luminosity = fp.getLuma();
        double[][] filtered = null;
        for (Kernel kernel : this.filters) {
            if (filtered == null) {
                filtered = kernel.apply(luminosity);
                continue;
            }
            filtered = kernel.apply(filtered);
        }
        double avgPixelValue = ArrayUtil.average(filtered);
        return this.computeHash(hash, filtered, avgPixelValue);
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash("com.github.kilianB.hashAlgorithms." + this.getClass().getSimpleName(), this.height, this.width, this.filters) * 31;
    }

    @Override
    public String toString() {
        return "AverageKernelHash [height=" + this.height + ", width=" + this.width + ", filters=" + this.filters + "]";
    }
}

