/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms;

import dev.brachtendorf.MathUtil;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashBuilder;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.Objects;

public class RotAverageHash
extends HashingAlgorithm {
    private static final long serialVersionUID = 128391293L;
    private int width;
    private int height;
    private double centerX;
    private double centerY;
    private int[] count = null;

    public RotAverageHash(int bitResolution) {
        super(bitResolution);
        int bucketPixelWidth = 2;
        this.height = this.width = (bitResolution + 1) * bucketPixelWidth;
        this.centerY = this.centerX = (double)(this.width - 1) / 2.0;
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        int i;
        boolean initCount;
        FastPixel fp = this.createPixelAccessor(image, this.width, this.height);
        double[] hashArr = new double[this.bitResolution + 2];
        boolean bl = initCount = this.count == null;
        if (initCount) {
            this.count = new int[hashArr.length];
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int bucket = this.computePartition(x, y);
                if (bucket >= hashArr.length) continue;
                if (initCount) {
                    int n = bucket;
                    this.count[n] = this.count[n] + 1;
                    int n2 = bucket;
                    hashArr[n2] = hashArr[n2] + (double)fp.getLuma(x, y);
                    continue;
                }
                int n = bucket;
                hashArr[n] = hashArr[n] + (double)fp.getLuma(x, y) / (double)this.count[bucket];
            }
        }
        if (initCount) {
            for (i = 0; i < hashArr.length; ++i) {
                int n = i;
                hashArr[n] = hashArr[n] / (double)this.count[i];
            }
        }
        for (i = 2; i < hashArr.length; ++i) {
            if (hashArr[i] >= hashArr[i - 1] || MathUtil.isDoubleEquals((double)hashArr[i], (double)hashArr[i - 1], (double)1.0E-6)) {
                hash.prependZero();
                continue;
            }
            hash.prependOne();
        }
        return hash.toBigInteger();
    }

    public int computePartition(double originalX, double originalY) {
        return (int)Math.round(Math.sqrt((originalX -= this.centerX) * originalX + (originalY -= this.centerY) * originalY));
    }

    @Override
    protected int precomputeAlgoId() {
        int doubleEqualsOffset = 3;
        return Objects.hash("com.github.kilianB.hashAlgorithms." + this.getClass().getSimpleName(), this.width, this.height, 3);
    }
}

