/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms;

import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashBuilder;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.Objects;

public class WaveletHash
extends HashingAlgorithm {
    private static final long serialVersionUID = -2259243765925949874L;
    private int width;
    private int height;
    private int cycles;

    public WaveletHash(int bitResolution, int cycles) {
        super(bitResolution);
        this.cycles = cycles;
        this.height = this.width = (int)Math.ceil(Math.sqrt((double)bitResolution * Math.pow(4.0, cycles)));
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hashBuilder) {
        int y;
        int x;
        FastPixel fp = this.createPixelAccessor(image, this.width, this.height);
        int[][] luma = fp.getLuma();
        double[][] transformed = WaveletHash.doHaar2DFWTransform(luma, this.cycles);
        double avg = 0.0;
        int subSpace = (int)Math.sqrt(this.bitResolution);
        int subSquared = subSpace * subSpace;
        for (x = 0; x < subSpace; ++x) {
            for (y = 0; y < subSpace; ++y) {
                avg += transformed[x][y] / (double)subSquared;
            }
        }
        for (x = 0; x < subSpace; ++x) {
            for (y = 0; y < subSpace; ++y) {
                if (transformed[x][y] > avg) {
                    hashBuilder.prependOne();
                    continue;
                }
                hashBuilder.prependZero();
            }
        }
        return hashBuilder.toBigInteger();
    }

    public static double[][] doHaar2DFWTransform(int[][] pixels, int cycles) {
        int j;
        int i;
        int w = pixels[0].length;
        int h = pixels.length;
        double[][] ds = new double[h][w];
        double[][] tempds = new double[h][w];
        for (i = 0; i < pixels.length; ++i) {
            for (j = 0; j < pixels[0].length; ++j) {
                ds[i][j] = pixels[i][j];
            }
        }
        for (i = 0; i < cycles; ++i) {
            double avgSub;
            double avgAdd;
            double sub;
            double add;
            double b;
            double a;
            int k;
            w /= 2;
            for (j = 0; j < h; ++j) {
                for (k = 0; k < w; ++k) {
                    a = ds[j][2 * k];
                    b = ds[j][2 * k + 1];
                    add = a + b;
                    sub = a - b;
                    avgAdd = add / 2.0;
                    avgSub = sub / 2.0;
                    tempds[j][k] = avgAdd;
                    tempds[j][k + w] = avgSub;
                }
            }
            for (j = 0; j < h; ++j) {
                for (k = 0; k < w; ++k) {
                    ds[j][k] = tempds[j][k];
                    ds[j][k + w] = tempds[j][k + w];
                }
            }
            h /= 2;
            for (j = 0; j < w; ++j) {
                for (k = 0; k < h; ++k) {
                    a = ds[2 * k][j];
                    b = ds[2 * k + 1][j];
                    add = a + b;
                    sub = a - b;
                    avgAdd = add / 2.0;
                    avgSub = sub / 2.0;
                    tempds[k][j] = avgAdd;
                    tempds[k + h][j] = avgSub;
                }
            }
            for (j = 0; j < w; ++j) {
                for (k = 0; k < h; ++k) {
                    ds[k][j] = tempds[k][j];
                    ds[k + h][j] = tempds[k + h][j];
                }
            }
        }
        return ds;
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash(this.width, this.height, this.cycles);
    }

    @Override
    public String toString() {
        return "WaveletHash [" + this.bitResolution + "," + this.cycles + "]";
    }
}

