/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms.filter;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.MiscUtil;
import dev.brachtendorf.Require;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.Filter;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.MultiKernel;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.function.BiFunction;

public class Kernel
implements Filter {
    private static final long serialVersionUID = -3490082941059458531L;
    protected double[][] mask;
    protected EdgeHandlingStrategy edgeHandling;

    public static Kernel identityFilter() {
        double[][] mask = new double[][]{{1.0}};
        return new Kernel(mask);
    }

    public static Kernel zeroFilter() {
        double[][] mask = new double[][]{{0.0}};
        return new Kernel(mask);
    }

    public static Kernel boxFilter(int width, int height, double factor) {
        double[][] xMask = new double[1][width];
        double[][] yMask = new double[height][1];
        double[] xInternal = new double[width];
        for (int i = 0; i < width; ++i) {
            xInternal[i] = factor;
        }
        xMask[0] = xInternal;
        ArrayUtil.fillArray((Object[])yMask, () -> new double[]{1.0});
        return new MultiKernel(yMask, xMask);
    }

    public static Kernel boxFilterNormalizedSep(int width, int height) {
        double factor = 1.0 / (double)(width * height);
        double[][] xMask = new double[1][width];
        double[][] yMask = new double[height][1];
        double[] xInternal = new double[width];
        for (int i = 0; i < width; ++i) {
            xInternal[i] = factor;
        }
        xMask[0] = xInternal;
        ArrayUtil.fillArray((Object[])yMask, () -> new double[]{1.0});
        return new MultiKernel(xMask, yMask);
    }

    public static Kernel boxFilterNormalized(int width, int height) {
        double factor = 1.0 / (double)(width * height);
        double[][] mask = new double[height][width];
        ArrayUtil.fillArrayMulti((Object)mask, () -> Double.valueOf(factor));
        return new Kernel(mask);
    }

    public static Kernel gaussianFilter(int width, int height, double std) {
        if (width % 2 == 0 || height % 2 == 0 || width < 1 || height < 1) {
            throw new IllegalArgumentException("Currently only odd sized kernels are suppoted. Width and height have to be positive");
        }
        Require.positiveValue((Number)std, (String)"Std has to be positive");
        double[][] mask = new double[width][height];
        double stdSquared = Math.pow(std, 2.0);
        int wHalf = width / 2;
        int hHalf = height / 2;
        for (int x = -wHalf; x <= wHalf; ++x) {
            for (int y = -hHalf; y <= hHalf; ++y) {
                double exponent = (double)(-(x * x + y * y)) / (2.0 * stdSquared);
                mask[x + wHalf][y + hHalf] = 1.0 / (Math.PI * 2 * stdSquared) * Math.pow(Math.E, exponent);
            }
        }
        return new Kernel(mask, true);
    }

    @Deprecated
    public static Kernel edgeDetectionFilter(int strength) {
        double[][] mask = new double[][]{{6.0, 10.0, 0.0}, {10.0, 0.0, -10.0}, {0.0, -10.0, -6.0}};
        return new Kernel((double[][])mask, true);
    }

    public static Kernel embossHorizontontalFilter(int depth) {
        depth = (Integer)Require.positiveValue((Number)depth, (String)"Depth has to be positive");
        double[][] mask = new double[1 + depth * 2][1 + depth * 2];
        int xMatch = mask.length / 2;
        for (int y = 0; y < mask.length; ++y) {
            if (y < xMatch) {
                mask[y][xMatch] = -1.0;
                continue;
            }
            if (y <= xMatch) continue;
            mask[y][xMatch] = 1.0;
        }
        return new GrayScaleFilter(mask);
    }

    public static Kernel embossLeftDiagonalFilter(int depth) {
        depth = (Integer)Require.positiveValue((Number)depth, (String)"Depth has to be positive");
        double[][] mask = new double[1 + depth * 2][1 + depth * 2];
        int xMatch = mask.length / 2;
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask.length; ++x) {
                if (x != y) continue;
                if (y < xMatch) {
                    mask[y][x] = -1.0;
                    continue;
                }
                if (y <= xMatch) continue;
                mask[y][x] = 1.0;
            }
        }
        return new GrayScaleFilter(mask);
    }

    public static Kernel embossRightDiagonalFilter(int depth) {
        depth = (Integer)Require.positiveValue((Number)depth, (String)"Depth has to be positive");
        double[][] mask = new double[1 + depth * 2][1 + depth * 2];
        int xMatch = mask.length / 2;
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask.length; ++x) {
                if (x + y != mask.length - 1) continue;
                if (y < xMatch) {
                    mask[y][x] = -1.0;
                    continue;
                }
                if (y <= xMatch) continue;
                mask[y][x] = 1.0;
            }
        }
        return new GrayScaleFilter(mask);
    }

    public static Kernel embossleftRightFilter(int depth) {
        depth = (Integer)Require.positiveValue((Number)depth, (String)"Depth has to be positive");
        double[][] mask = new double[1 + depth * 2][1 + depth * 2];
        int xMatch = mask.length / 2;
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask.length; ++x) {
                if (y != xMatch) continue;
                if (x < xMatch) {
                    mask[y][x] = -1.0;
                    continue;
                }
                if (x <= xMatch) continue;
                mask[y][x] = 1.0;
            }
        }
        return new GrayScaleFilter(mask);
    }

    public Kernel(Kernel template) {
        this.edgeHandling = template.edgeHandling;
        try {
            this.mask = (double[][])ArrayUtil.deepArrayCopyClone((Object[])template.mask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    protected Kernel(EdgeHandlingStrategy strat) {
        this.edgeHandling = strat;
    }

    public Kernel(double[][] mask) {
        this(mask, EdgeHandlingStrategy.EXPAND, false);
    }

    public Kernel(double[][] mask, boolean normalize) {
        this(mask, EdgeHandlingStrategy.EXPAND, normalize);
    }

    public Kernel(double[][] mask, EdgeHandlingStrategy edgeHandling) {
        this(mask, edgeHandling, false);
    }

    public Kernel(double[][] mask, EdgeHandlingStrategy edgeHandling, boolean normalize) {
        if (mask.length % 2 == 0 || mask[0].length % 2 == 0) {
            throw new IllegalArgumentException("Currently only odd width and height kernels are supported");
        }
        if (normalize) {
            double maskSum = 0.0;
            double[][] dArray = mask;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] m;
                for (double d : m = dArray[i]) {
                    maskSum += d;
                }
            }
            if (maskSum != 0.0) {
                for (double[] m : mask) {
                    int i = 0;
                    while (i < m.length) {
                        int n2 = i++;
                        m[n2] = m[n2] / maskSum;
                    }
                }
            }
        }
        this.mask = mask;
        this.edgeHandling = edgeHandling;
    }

    public double[][] apply(int[][] input) {
        double[][] result = new double[input.length][input[0].length];
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result[y][x] = this.calcValue(input, x, y);
            }
        }
        return result;
    }

    public int[][] applyInt(int[][] input) {
        int[][] result = new int[input.length][input[0].length];
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result[y][x] = (int)Math.round(this.calcValue(input, x, y));
            }
        }
        return result;
    }

    public int[][] applyInt(double[][] input) {
        int[][] result = new int[input.length][input[0].length];
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result[y][x] = (int)Math.round(this.calcValue(input, x, y));
            }
        }
        return result;
    }

    public double[][] apply(double[][] input) {
        double[][] result = new double[input.length][input[0].length];
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result[y][x] = this.calcValue(input, x, y);
            }
        }
        return result;
    }

    public double[][] apply(byte[][] input) {
        double[][] result = new double[input.length][input[0].length];
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result[y][x] = this.calcValue(input, x, y);
            }
        }
        return result;
    }

    public byte[][] applyByte(byte[][] input) {
        byte[][] result = new byte[input.length][input[0].length];
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result[y][x] = (byte)Math.round(this.calcValue(input, x, y));
            }
        }
        return result;
    }

    public byte[][] applyByte(double[][] input) {
        byte[][] result = new byte[input.length][input[0].length];
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result[y][x] = (byte)Math.round(this.calcValue(input, x, y));
            }
        }
        return result;
    }

    protected double calcValue(byte[][] input, int x, int y) {
        double value = 0.0;
        int maskW = this.mask[0].length / 2;
        int maskH = this.mask.length / 2;
        int width = input[0].length;
        int height = input.length;
        for (int yMask = -maskH; yMask <= maskH; ++yMask) {
            for (int xMask = -maskW; xMask <= maskW; ++xMask) {
                int yPixelIndex;
                int xPixelIndex;
                if (this.edgeHandling.equals((Object)EdgeHandlingStrategy.NO_OP)) {
                    xPixelIndex = x + xMask;
                    yPixelIndex = y + yMask;
                    if (xPixelIndex < 0 || xPixelIndex >= width || yPixelIndex < 0 || yPixelIndex >= height) {
                        return input[y][x];
                    }
                } else {
                    xPixelIndex = this.edgeHandling.correctPixel(x + xMask, width);
                    yPixelIndex = this.edgeHandling.correctPixel(y + yMask, height);
                }
                value += this.mask[yMask + maskH][xMask + maskW] * (double)input[yPixelIndex][xPixelIndex];
            }
        }
        return value;
    }

    protected double calcValue(int[][] input, int x, int y) {
        double value = 0.0;
        int maskW = this.mask[0].length / 2;
        int maskH = this.mask.length / 2;
        int width = input[0].length;
        int height = input.length;
        for (int yMask = -maskH; yMask <= maskH; ++yMask) {
            for (int xMask = -maskW; xMask <= maskW; ++xMask) {
                int yPixelIndex;
                int xPixelIndex;
                if (this.edgeHandling.equals((Object)EdgeHandlingStrategy.NO_OP)) {
                    xPixelIndex = x + xMask;
                    yPixelIndex = y + yMask;
                    if (xPixelIndex < 0 || xPixelIndex >= width || yPixelIndex < 0 || yPixelIndex >= height) {
                        return input[y][x];
                    }
                } else {
                    xPixelIndex = this.edgeHandling.correctPixel(x + xMask, width);
                    yPixelIndex = this.edgeHandling.correctPixel(y + yMask, height);
                }
                value += this.mask[yMask + maskH][xMask + maskW] * (double)input[yPixelIndex][xPixelIndex];
            }
        }
        return value;
    }

    protected double calcValue(double[][] input, int x, int y) {
        double value = 0.0;
        int maskW = this.mask[0].length / 2;
        int maskH = this.mask.length / 2;
        int width = input[0].length;
        int height = input.length;
        for (int yMask = -maskH; yMask <= maskH; ++yMask) {
            for (int xMask = -maskW; xMask <= maskW; ++xMask) {
                int yPixelIndex;
                int xPixelIndex;
                if (this.edgeHandling.equals((Object)EdgeHandlingStrategy.NO_OP)) {
                    xPixelIndex = x + xMask;
                    yPixelIndex = y + yMask;
                    if (xPixelIndex < 0 || xPixelIndex >= width || yPixelIndex < 0 || yPixelIndex >= height) {
                        return input[y][x];
                    }
                } else {
                    xPixelIndex = this.edgeHandling.correctPixel(x + xMask, width);
                    yPixelIndex = this.edgeHandling.correctPixel(y + yMask, height);
                }
                value += this.mask[yMask + maskH][xMask + maskW] * input[yPixelIndex][xPixelIndex];
            }
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edgeHandling == null ? 0 : MiscUtil.consistentHashCode((Enum)this.edgeHandling));
        result = 31 * result + Arrays.deepHashCode((Object[])this.mask);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Kernel other = (Kernel)obj;
        if (this.edgeHandling != other.edgeHandling) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.mask, (Object[])other.mask);
    }

    public String toString() {
        return "Kernel [edgeHandling=" + this.edgeHandling + ", mask=\n" + ArrayUtil.deepToStringFormatted((Object[])this.mask) + "]";
    }

    @Override
    public BufferedImage filter(BufferedImage input) {
        BufferedImage bi = new BufferedImage(input.getWidth(), input.getHeight(), input.getType());
        FastPixel fp = FastPixel.create((BufferedImage)input);
        FastPixel fpSet = FastPixel.create((BufferedImage)bi);
        int[][] red = fp.getRed();
        int[][] green = fp.getGreen();
        int[][] blue = fp.getBlue();
        red = this.applyInt(red);
        green = this.applyInt(green);
        blue = this.applyInt(blue);
        fpSet.setRed(red);
        fpSet.setGreen(green);
        fpSet.setBlue(blue);
        if (fpSet.hasAlpha()) {
            fpSet.setAlpha(fp.getAlpha());
        }
        return bi;
    }

    public static class GrayScaleFilter
    extends Kernel {
        private static final long serialVersionUID = -1079407275717629013L;

        public GrayScaleFilter(double[][] mask) {
            super(mask);
        }

        @Override
        public BufferedImage filter(BufferedImage input) {
            BufferedImage bi = new BufferedImage(input.getWidth(), input.getHeight(), input.getType());
            FastPixel fp = FastPixel.create((BufferedImage)input);
            FastPixel fpSet = FastPixel.create((BufferedImage)bi);
            int[][] gray = fp.getAverageGrayscale();
            gray = this.applyInt(gray);
            fpSet.setAverageGrayscale(gray);
            return bi;
        }
    }

    public static enum EdgeHandlingStrategy {
        NO_OP(null),
        EXPAND((pIndex, wHeight) -> {
            if (pIndex < 0) {
                return 0;
            }
            if (pIndex >= wHeight) {
                return wHeight - 1;
            }
            return pIndex;
        }),
        MIRROR((pIndex, wHeight) -> {
            if (pIndex < 0) {
                return -pIndex.intValue();
            }
            if (pIndex >= wHeight) {
                return wHeight - (pIndex - wHeight) - 1;
            }
            return pIndex;
        }),
        WRAP((pIndex, wHeight) -> {
            if (pIndex < 0) {
                return wHeight + pIndex;
            }
            if (pIndex >= wHeight) {
                return 0 + wHeight - pIndex;
            }
            return pIndex;
        });

        private BiFunction<Integer, Integer, Integer> compute;

        private EdgeHandlingStrategy(BiFunction<Integer, Integer, Integer> func) {
            this.compute = func;
        }

        public int correctPixel(int pIndex, int widthOrHeight) {
            return this.compute.apply(pIndex, widthOrHeight);
        }
    }
}

