/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms.filter;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.Kernel;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.NonAveragingKernel;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class MedianKernel
extends NonAveragingKernel {
    private static final long serialVersionUID = 5756361510407136992L;

    public MedianKernel(int width, int height) {
        super(Kernel.EdgeHandlingStrategy.EXPAND);
        if (width <= 0 || width % 2 == 0 || height <= 0 || height % 2 == 0) {
            throw new IllegalArgumentException("Currently only odd dimensional kernels are supported. Width & height have to be positive");
        }
        double[][] mask = new double[width][height];
        ArrayUtil.fillArrayMulti((Object)mask, () -> Double.valueOf(1.0));
        this.mask = mask;
    }

    public MedianKernel(double[][] mask) {
        super(mask);
    }

    @Override
    protected double calcValue(byte[][] input, int x, int y) {
        return this.resolveMedian(this.computePotentialValues(input, x, y));
    }

    @Override
    protected double calcValue(int[][] input, int x, int y) {
        return this.resolveMedian(this.computePotentialValues(input, x, y));
    }

    @Override
    protected double calcValue(double[][] input, int x, int y) {
        return this.resolveMedian(this.computePotentialValues(input, x, y));
    }

    protected double resolveMedian(double[][] values) {
        if (values[1].length == 1 && values[1][0] == Double.MIN_VALUE) {
            return values[0][0];
        }
        Arrays.sort(values[0]);
        int halfIndex = values.length / 2;
        if (values.length % 2 == 0) {
            return (values[0][halfIndex] + values[0][halfIndex + 1]) / 2.0;
        }
        return values[0][halfIndex];
    }

    @Override
    public BufferedImage filter(BufferedImage input) {
        BufferedImage bi = new BufferedImage(input.getWidth(), input.getHeight(), input.getType());
        FastPixel fp = FastPixel.create((BufferedImage)input);
        FastPixel fpSet = FastPixel.create((BufferedImage)bi);
        int[][] gray = fp.getAverageGrayscale();
        gray = this.applyInt(gray);
        if (fpSet.hasAlpha()) {
            fpSet.setAlpha(fp.getAlpha());
        }
        fpSet.setAverageGrayscale(gray);
        return bi;
    }
}

