/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms.filter;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.Kernel;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.NonAveragingKernel;

public class MinimumKernel
extends NonAveragingKernel {
    private static final long serialVersionUID = -2271995765850760974L;

    public MinimumKernel(int width, int height) {
        super(Kernel.EdgeHandlingStrategy.EXPAND);
        if (width <= 0 || width % 2 == 0 || height <= 0 || height % 2 == 0) {
            throw new IllegalArgumentException("Currently only odd dimensional kernels are supported. Width & height have to be positive");
        }
        double[][] mask = new double[width][height];
        ArrayUtil.fillArrayMulti((Object)mask, () -> Double.valueOf(1.0));
        this.mask = mask;
    }

    public MinimumKernel(double[][] mask) {
        super(mask);
    }

    @Override
    protected double calcValue(byte[][] input, int x, int y) {
        return this.resolveMax(this.computePotentialValues(input, x, y));
    }

    @Override
    protected double calcValue(int[][] input, int x, int y) {
        return this.resolveMax(this.computePotentialValues(input, x, y));
    }

    @Override
    protected double calcValue(double[][] input, int x, int y) {
        return this.resolveMax(this.computePotentialValues(input, x, y));
    }

    protected double resolveMax(double[][] values) {
        if (values[1].length == 1 && values[1][0] == Double.MIN_VALUE) {
            return values[0][0];
        }
        return values[0][ArrayUtil.minimumIndex((double[])values[1])];
    }
}

