/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.persistent;

import dev.brachtendorf.jimagehash.datastructures.tree.Result;
import dev.brachtendorf.jimagehash.datastructures.tree.binaryTree.BinaryTree;
import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import dev.brachtendorf.jimagehash.matcher.persistent.ConsecutiveMatcher;
import dev.brachtendorf.jimagehash.matcher.persistent.PersistentImageMatcher;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.logging.Logger;

public abstract class PersitentBinaryTreeMatcher
extends PersistentImageMatcher {
    private static final long serialVersionUID = -4650598803470549478L;
    private static final Logger LOGGER = Logger.getLogger(ConsecutiveMatcher.class.getSimpleName());
    protected HashSet<String> addedImages = new HashSet();
    protected HashMap<HashingAlgorithm, BinaryTree<String>> binTreeMap = new HashMap();
    protected boolean cacheAddedHashes;
    protected Map<HashingAlgorithm, Map<String, Hash>> cachedHashes;

    public PersitentBinaryTreeMatcher(boolean cacheAddedHashes) {
        this.cacheAddedHashes = cacheAddedHashes;
        if (cacheAddedHashes) {
            this.cachedHashes = new HashMap<HashingAlgorithm, Map<String, Hash>>();
        }
    }

    @Override
    public PriorityQueue<Result<String>> getMatchingImages(File image) throws IOException {
        if (this.cacheAddedHashes && this.addedImages.contains(image.getAbsolutePath())) {
            return this.getMatchingImagesInternal(null, image.getAbsolutePath());
        }
        return super.getMatchingImages(image);
    }

    @Override
    public PriorityQueue<Result<String>> getMatchingImages(BufferedImage image) {
        return this.getMatchingImagesInternal(image, null);
    }

    protected abstract PriorityQueue<Result<String>> getMatchingImagesInternal(BufferedImage var1, String var2);

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold, boolean normalized) {
        super.addHashingAlgorithm(algo, threshold, normalized);
        BinaryTree binTree = new BinaryTree(true);
        this.binTreeMap.put(algo, binTree);
        if (this.cacheAddedHashes) {
            this.cachedHashes.put(algo, new HashMap());
        }
    }

    @Override
    public boolean removeHashingAlgo(HashingAlgorithm algo) {
        this.binTreeMap.remove(algo);
        if (this.cacheAddedHashes) {
            this.cachedHashes.remove(algo);
        }
        return super.removeHashingAlgo(algo);
    }

    @Override
    public void clearHashingAlgorithms() {
        this.binTreeMap.clear();
        if (this.cacheAddedHashes) {
            this.cachedHashes.clear();
        }
        super.clearHashingAlgorithms();
    }

    @Override
    protected void addImageInternal(String uniqueId, BufferedImage image) {
        if (this.addedImages.contains(uniqueId)) {
            LOGGER.info("An image with uniqueId already exists. Skip request");
        }
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            BinaryTree<String> binTree = this.binTreeMap.get(algo);
            Hash hash = algo.hash(image);
            binTree.addHash(algo.hash(image), uniqueId);
            if (!this.cacheAddedHashes) continue;
            this.cachedHashes.get(algo).put(uniqueId, hash);
        }
        this.addedImages.add(uniqueId);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.addedImages == null ? 0 : this.addedImages.hashCode());
        result = 31 * result + (this.binTreeMap == null ? 0 : this.binTreeMap.hashCode());
        result = 31 * result + (this.cacheAddedHashes ? 1231 : 1237);
        result = 31 * result + (this.cachedHashes == null ? 0 : this.cachedHashes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PersitentBinaryTreeMatcher)) {
            return false;
        }
        PersitentBinaryTreeMatcher other = (PersitentBinaryTreeMatcher)obj;
        if (this.addedImages == null ? other.addedImages != null : !this.addedImages.equals(other.addedImages)) {
            return false;
        }
        if (this.binTreeMap == null ? other.binTreeMap != null : !this.binTreeMap.equals(other.binTreeMap)) {
            return false;
        }
        if (this.cacheAddedHashes != other.cacheAddedHashes) {
            return false;
        }
        return !(this.cachedHashes == null ? other.cachedHashes != null : !this.cachedHashes.equals(other.cachedHashes));
    }

    protected Hash getHash(HashingAlgorithm algo, String uniqueId, BufferedImage bImage) {
        if (uniqueId != null && this.cachedHashes.get(algo).containsKey(uniqueId)) {
            return this.cachedHashes.get(algo).get(uniqueId);
        }
        if (bImage != null) {
            return algo.hash(bImage);
        }
        throw new IllegalStateException("No hash and buffered image supplied. Can't retrieve hash");
    }

    public void printAllTrees() {
        this.binTreeMap.entrySet().forEach(c -> ((BinaryTree)c.getValue()).printTree());
    }
}

