/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.persistent.database;

import dev.brachtendorf.jimagehash.datastructures.tree.Result;
import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import dev.brachtendorf.jimagehash.matcher.TypedImageMatcher;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class DatabaseImageMatcher
extends TypedImageMatcher
implements Serializable,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(DatabaseImageMatcher.class.getName());
    private static final long serialVersionUID = 1L;
    protected transient Connection conn;

    public DatabaseImageMatcher(Connection connection) throws SQLException {
        this.initialize(connection);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static DatabaseImageMatcher getFromDatabase(Connection conn, int id) throws SQLException {
        block12: {
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery("SELECT * FROM ImageHasher WHERE ID = " + id);
                if (!rs.next()) break block12;
                try {
                    DatabaseImageMatcher matcher = (DatabaseImageMatcher)new ObjectInputStream(rs.getBlob(2).getBinaryStream()).readObject();
                    matcher.conn = conn;
                    DatabaseImageMatcher databaseImageMatcher = matcher;
                    return databaseImageMatcher;
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("Table \"IMAGEHASHER\" not found")) {
                    LOG.warning("Tried to retrieve matcher from not compatible database");
                }
                throw exception;
            }
        }
        conn.close();
        return null;
    }

    protected void initialize(Connection conn) throws SQLException {
        this.conn = conn;
        try (Statement stmt = conn.createStatement();){
            if (!this.doesTableExist("ImageHasher")) {
                stmt.execute("CREATE TABLE ImageHasher (Id INTEGER PRIMARY KEY, SerializeData BLOB)");
            }
        }
    }

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold) {
        try {
            if (!this.doesTableExist(this.resolveTableName(algo))) {
                this.createHashTable(algo);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        super.addHashingAlgorithm(algo, threshold);
    }

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold, boolean normalized) {
        try {
            if (!this.doesTableExist(this.resolveTableName(algo))) {
                this.createHashTable(algo);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        super.addHashingAlgorithm(algo, threshold, normalized);
    }

    public void addImage(File imageFile) throws IOException, SQLException {
        this.addImage(imageFile.getAbsolutePath(), imageFile);
    }

    public void addImage(String uniqueId, File imageFile) throws IOException, SQLException {
        BufferedImage img = null;
        for (HashingAlgorithm algo : this.steps.keySet()) {
            if (this.doesEntryExist(uniqueId, algo)) continue;
            if (img == null) {
                img = ImageIO.read(imageFile);
            }
            this.addImage(algo, uniqueId, img);
        }
    }

    public void addImages(File ... images) throws IOException, SQLException {
        for (File img : images) {
            this.addImage(img);
        }
    }

    public void addImages(String[] uniqueIds, File[] images) throws IOException, SQLException {
        if (uniqueIds.length != images.length) {
            throw new IllegalArgumentException("You need to supply the same number of id's and images");
        }
        for (int i = 0; i < uniqueIds.length; ++i) {
            this.addImage(uniqueIds[i], images[i]);
        }
    }

    public void addImage(String uniqueId, BufferedImage image) throws SQLException {
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            if (this.doesEntryExist(uniqueId, algo)) continue;
            this.addImage(algo, uniqueId, image);
        }
    }

    public void addImages(String[] uniqueIds, BufferedImage[] images) throws SQLException {
        if (uniqueIds.length != images.length) {
            throw new IllegalArgumentException("You need to supply the same number of id's and images");
        }
        for (int i = 0; i < uniqueIds.length; ++i) {
            for (Map.Entry entry : this.steps.entrySet()) {
                HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
                if (this.doesEntryExist(uniqueIds[i], algo)) continue;
                this.addImage(algo, uniqueIds[i], images[i]);
            }
        }
    }

    public void serializeToDatabase(int id) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("MERGE INTO ImageHasher (Id,SerializeData) VALUES(?,?)");
        PipedOutputStream pipeOut = new PipedOutputStream();
        try {
            PipedInputStream pipe = new PipedInputStream(pipeOut);
            ObjectOutputStream oos = new ObjectOutputStream(pipeOut);
            oos.writeObject(this);
            oos.close();
            ps.setInt(1, id);
            ps.setBinaryStream(2, pipe);
            ps.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean removeHashingAlgo(HashingAlgorithm algo, boolean forceTableDeletion) throws SQLException {
        String tableName;
        boolean removed = this.removeHashingAlgo(algo);
        if (removed && forceTableDeletion && this.doesTableExist(tableName = this.resolveTableName(algo))) {
            try (Statement stmt = this.conn.createStatement();){
                stmt.execute("DROP TABLE " + tableName);
            }
        }
        return removed;
    }

    public void clearHashingAlgorithms(boolean forceTableDeletion) throws SQLException {
        if (forceTableDeletion) {
            ArrayList<HashingAlgorithm> hasher = new ArrayList<HashingAlgorithm>(this.getAlgorithms().keySet());
            for (HashingAlgorithm hashingAlgo : hasher) {
                this.removeHashingAlgo(hashingAlgo, true);
            }
        }
        super.clearHashingAlgorithms();
    }

    public Map<String, PriorityQueue<Result<String>>> getAllMatchingImages() throws SQLException {
        HashMap<String, PriorityQueue<Result<String>>> returnVal = new HashMap<String, PriorityQueue<Result<String>>>();
        HashingAlgorithm hasher = (HashingAlgorithm)this.steps.keySet().iterator().next();
        String tableName = this.resolveTableName(hasher);
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT url FROM " + tableName);
        HashMap<HashingAlgorithm, PreparedStatement> cachedStatements = new HashMap<HashingAlgorithm, PreparedStatement>();
        for (HashingAlgorithm hashAlgo : this.steps.keySet()) {
            cachedStatements.put(hashAlgo, this.conn.prepareStatement("SELECT hash FROM " + this.resolveTableName(hashAlgo) + " WHERE url = ?"));
        }
        while (rs.next()) {
            String id = rs.getString(1);
            PriorityQueue<Result<String>> returnValues = null;
            for (Map.Entry entry1 : this.steps.entrySet()) {
                HashingAlgorithm algo = (HashingAlgorithm)entry1.getKey();
                PreparedStatement ps = (PreparedStatement)cachedStatements.get(algo);
                ps.setString(1, id);
                ResultSet targetHashRs = ps.executeQuery();
                targetHashRs.next();
                Hash targetHash = this.reconstructHashFromDatabase(algo, targetHashRs.getBytes(1));
                TypedImageMatcher.AlgoSettings settings = (TypedImageMatcher.AlgoSettings)entry1.getValue();
                int threshold = 0;
                if (settings.isNormalized()) {
                    int hashLength = targetHash.getBitResolution();
                    threshold = (int)Math.round(settings.getThreshold() * (double)hashLength);
                } else {
                    threshold = (int)settings.getThreshold();
                }
                PriorityQueue<Result<String>> temp = new PriorityQueue<Result<String>>(this.getSimilarImages(targetHash, threshold, algo));
                if (returnValues == null) {
                    returnValues = temp;
                    continue;
                }
                temp.retainAll(returnValues);
                returnValues = temp;
            }
            returnVal.put(id, returnValues);
        }
        return returnVal;
    }

    public PriorityQueue<Result<String>> getMatchingImagesWithinDistance(BufferedImage image, double[] normalizedDistance) throws SQLException {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        PriorityQueue<Result<String>> returnValues = null;
        Map.Entry[] entries = this.steps.entrySet().toArray(new Map.Entry[this.steps.size()]);
        for (int i = 0; i < this.steps.size(); ++i) {
            HashingAlgorithm algo = (HashingAlgorithm)entries[i].getKey();
            Hash targetHash = algo.hash(image);
            int threshold = (int)Math.round(normalizedDistance[i] * (double)targetHash.getBitResolution());
            PriorityQueue<Result<String>> temp = new PriorityQueue<Result<String>>(this.getSimilarImages(targetHash, threshold, algo));
            if (returnValues == null) {
                returnValues = temp;
                continue;
            }
            temp.retainAll(returnValues);
            returnValues = temp;
        }
        return returnValues;
    }

    public PriorityQueue<Result<String>> getMatchingImages(File imageFile) throws SQLException, IOException {
        return this.getMatchingImages(ImageIO.read(imageFile));
    }

    public PriorityQueue<Result<String>> getMatchingImages(BufferedImage image) throws SQLException {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        PriorityQueue<Result<String>> returnValues = null;
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            Hash targetHash = algo.hash(image);
            TypedImageMatcher.AlgoSettings settings = (TypedImageMatcher.AlgoSettings)entry.getValue();
            int threshold = 0;
            if (settings.isNormalized()) {
                int hashLength = targetHash.getBitResolution();
                threshold = (int)Math.round(settings.getThreshold() * (double)hashLength);
            } else {
                threshold = (int)settings.getThreshold();
            }
            PriorityQueue<Result<String>> temp = new PriorityQueue<Result<String>>(this.getSimilarImages(targetHash, threshold, algo));
            if (returnValues == null) {
                returnValues = temp;
                continue;
            }
            temp.retainAll(returnValues);
            returnValues = temp;
        }
        return returnValues;
    }

    protected List<Result<String>> getSimilarImages(Hash targetHash, int maxDistance, HashingAlgorithm hasher) throws SQLException {
        String tableName = this.resolveTableName(hasher);
        ArrayList<Result<String>> urls = new ArrayList<Result<String>>();
        try (Statement stmt = this.conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT url,hash FROM " + tableName);
            while (rs.next()) {
                byte[] bytes = rs.getBytes(2);
                Hash h = this.reconstructHashFromDatabase(hasher, bytes);
                int distance = targetHash.hammingDistanceFast(h);
                double normalizedDistance = (double)distance / (double)targetHash.getBitResolution();
                if (distance > maxDistance) continue;
                String url = rs.getString(1);
                urls.add(new Result<String>(url, distance, normalizedDistance));
            }
        }
        return urls;
    }

    protected void addImage(HashingAlgorithm hashAlgo, String url, BufferedImage image) throws SQLException {
        String tableName = this.resolveTableName(hashAlgo);
        if (!this.doesTableExist(tableName)) {
            this.createHashTable(hashAlgo);
        }
        try (PreparedStatement insertHash = this.conn.prepareStatement("MERGE INTO " + tableName + " (url,hash) VALUES(?,?)");){
            Hash hash = hashAlgo.hash(image);
            insertHash.setString(1, url);
            insertHash.setBytes(2, hash.toByteArray());
            insertHash.execute();
        }
    }

    protected void createHashTable(HashingAlgorithm hasher) throws SQLException {
        String tableName = this.resolveTableName(hasher);
        if (this.doesTableExist(tableName)) {
            return;
        }
        try (Statement stmt = this.conn.createStatement();){
            BufferedImage bi = new BufferedImage(1, 1, 5);
            Hash sampleHash = hasher.hash(bi);
            int bytes = (int)Math.ceil((double)sampleHash.getBitResolution() / 8.0);
            stmt.execute("CREATE TABLE " + tableName + " (url VARCHAR(260) PRIMARY KEY, hash BINARY(" + bytes + "))");
        }
    }

    protected boolean doesTableExist(String tableName) throws SQLException {
        DatabaseMetaData metadata = this.conn.getMetaData();
        ResultSet res = metadata.getTables(null, null, tableName.toUpperCase(), new String[]{"TABLE"});
        boolean exist = res.next();
        return exist;
    }

    protected String resolveTableName(HashingAlgorithm hashAlgo) {
        return hashAlgo.getClass().getSimpleName() + (Serializable)(hashAlgo.algorithmId() > 0 ? Integer.valueOf(hashAlgo.algorithmId()) : "m" + Math.abs(hashAlgo.algorithmId()));
    }

    protected Hash reconstructHashFromDatabase(HashingAlgorithm hasher, byte[] bytes) {
        byte[] bArrayWithSign = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, bArrayWithSign, 1, bytes.length);
        BigInteger bInt = new BigInteger(bArrayWithSign);
        return new Hash(bInt, hasher.getKeyResolution(), hasher.algorithmId());
    }

    public String toString() {
        return "DatabaseImageMatcher [steps=" + this.steps + "]";
    }

    public boolean doesEntryExist(String uniqueId, HashingAlgorithm hashAlgo) throws SQLException {
        try (PreparedStatement doesEntryExist = this.conn.prepareStatement("SELECT * FROM " + this.resolveTableName(hashAlgo) + " WHERE URL = ?");){
            doesEntryExist.setString(1, uniqueId);
            boolean bl = doesEntryExist.executeQuery().next();
            return bl;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.steps);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.steps = (LinkedHashMap)ois.readObject();
    }

    @Override
    public void close() throws SQLException {
        this.conn.commit();
        this.conn.close();
    }
}

