/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.persistent.database;

import dev.brachtendorf.jimagehash.matcher.persistent.database.DatabaseImageMatcher;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.h2.tools.DeleteDbFiles;

public class H2DatabaseImageMatcher
extends DatabaseImageMatcher {
    private static final long serialVersionUID = 5629316725655117532L;
    private static final Logger LOG = Logger.getLogger(H2DatabaseImageMatcher.class.getName());
    private static final String CLASS_NOT_FOUND_ERROR = "In order to use the default database image matcher please make sure to add a h2 dependency to the class path. (Last tested version: 1.4.197).";

    public static H2DatabaseImageMatcher getFromDatabase(String subname, String user, String password, int id) throws SQLException {
        return (H2DatabaseImageMatcher)H2DatabaseImageMatcher.getFromDatabase(H2DatabaseImageMatcher.getConnection(subname, user, password), id);
    }

    public H2DatabaseImageMatcher(String subname, String user, String password) throws SQLException {
        this(H2DatabaseImageMatcher.getConnection(subname, user, password));
    }

    public H2DatabaseImageMatcher(Connection dbConnection) throws SQLException {
        super(H2DatabaseImageMatcher.checkConnection(dbConnection));
    }

    public void deleteDatabase() throws SQLException {
        block7: {
            try (Statement stm = this.conn.createStatement();){
                String url = this.conn.getMetaData().getURL();
                String needle = "jdbc:h2:";
                if (url.startsWith(needle)) {
                    int dbNameIndex = url.lastIndexOf("/");
                    String path = url.substring(needle.length(), dbNameIndex);
                    String dbName = url.substring(dbNameIndex + 1);
                    this.close();
                    DeleteDbFiles.execute((String)path, (String)dbName, (boolean)true);
                    break block7;
                }
                String msg = "deleteDatabase currently not supported for non h2 drivers.";
                LOG.severe(msg);
                throw new UnsupportedOperationException(msg);
            }
        }
    }

    private static Connection getConnection(String subname, String user, String password) throws SQLException {
        try {
            return DriverManager.getConnection("jdbc:h2:~/" + subname, user, password);
        }
        catch (SQLException exception) {
            if (exception.getMessage().contains("No suitable driver found")) {
                LOG.severe(CLASS_NOT_FOUND_ERROR);
            }
            throw exception;
        }
    }

    private static Connection checkConnection(Connection dbConnection) throws IllegalArgumentException {
        if ("org.h2.jdbc.JdbcConnection".contains(dbConnection.getClass().getName())) {
            return dbConnection;
        }
        throw new IllegalArgumentException("To intialize a h2dbimagematcher you must supply a h2 connection. Did you want to create a DatabaseImageMatcher instead?");
    }
}

