/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtil {
    private static final int IV_LENGTH = 16;

    public static SecretKey deriveKey(char[] password, byte[] salt, int keyLength) throws InvalidKeySpecException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, keyLength);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            return secret;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SecretKey deriveKey(char[] password) {
        try {
            return CryptoUtil.deriveKey(password, "FixedSalt".getBytes(), 128);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptAES(SecretKey key, String text) throws Exception {
        byte[] initVector = new byte[16];
        new SecureRandom().nextBytes(initVector);
        IvParameterSpec iv = new IvParameterSpec(initVector);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)key, iv);
        byte[] encrypted = cipher.doFinal(text.getBytes());
        byte[] finalWithIV = new byte[encrypted.length + initVector.length];
        System.arraycopy(initVector, 0, finalWithIV, 0, initVector.length);
        System.arraycopy(encrypted, 0, finalWithIV, initVector.length, encrypted.length);
        return new String(Base64.getEncoder().encode(finalWithIV));
    }

    public static String decrypt(SecretKey key, String encrypted) throws Exception {
        byte[] inputWithIV = Base64.getDecoder().decode(encrypted);
        IvParameterSpec iv = new IvParameterSpec(inputWithIV, 0, 16);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)key, iv);
        byte[] original = cipher.doFinal(inputWithIV, 16, inputWithIV.length - 16);
        return new String(original);
    }
}

