/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;

public class MiscUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartApp() {
        Runnable restartApp = new Runnable(){

            @Override
            public void run() {
                String java = System.getProperty("java.home") + "/bin/java";
                List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
                StringBuffer vmArgsOneLine = new StringBuffer();
                for (String arg : vmArguments) {
                    if (arg.contains("-agentlib")) continue;
                    vmArgsOneLine.append(arg);
                    vmArgsOneLine.append(" ");
                }
                StringBuffer cmd = new StringBuffer("\"" + java + "\" " + vmArgsOneLine);
                String[] mainCommand = System.getProperty("sun.java.command").split(" ");
                if (mainCommand[0].endsWith(".jar")) {
                    cmd.append("-jar " + new File(mainCommand[0]).getPath());
                } else {
                    cmd.append("-cp \"" + System.getProperty("java.class.path") + "\" " + mainCommand[0]);
                }
                for (int i = 1; i < mainCommand.length; ++i) {
                    cmd.append(" ");
                    cmd.append(mainCommand[i]);
                }
                try {
                    Runtime.getRuntime().exec(cmd.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            Class<?> shutdownClass = Class.forName("java.lang.Shutdown");
            Method registerShutdownSlot = shutdownClass.getDeclaredMethod("add", Integer.TYPE, Boolean.TYPE, Runnable.class);
            for (int i = 3; i < 10; ++i) {
                try {
                    registerShutdownSlot.setAccessible(true);
                    registerShutdownSlot.invoke(null, i, false, restartApp);
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    continue;
                }
                finally {
                    registerShutdownSlot.setAccessible(false);
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("Error registering shutdown hook " + e.getMessage() + e);
        }
        System.exit(0);
    }

    public static int consistentHashCode(Enum e) {
        return e.name().hashCode() * 31 + e.ordinal() ^ e.getClass().getName().hashCode();
    }

    public static enum OS {
        WINDOWS("windows"),
        LINUX("linux"),
        SOLARIS("sunos", "solaris"),
        MAC_OS("darwin", "mac", "macos", "mac os x"),
        UNKNOWN("generic"),
        OTHER("");

        private static OS currentOS;
        private String[] osIdentifier;

        public static OS getOS() {
            return currentOS == null ? OS.retrieveInfo() : currentOS;
        }

        public String toString() {
            Object osPretty = currentOS.name().toLowerCase().replace("_", " ");
            osPretty = ((String)osPretty).substring(0, 1).toUpperCase() + ((String)osPretty).substring(1);
            int index = 0;
            while ((index = ((String)osPretty).indexOf(" ", index + 1)) != -1) {
                osPretty = ((String)osPretty).substring(0, 1).toUpperCase() + ((String)osPretty).substring(1);
            }
            return (String)osPretty + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        }

        private static OS retrieveInfo() {
            String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            for (OS os : OS.values()) {
                for (String identifier : os.osIdentifier) {
                    if (!osName.contains(identifier)) continue;
                    currentOS = os;
                    return currentOS;
                }
            }
            return OTHER;
        }

        private OS(String ... haystack) {
            this.osIdentifier = haystack;
        }

        static {
            currentOS = null;
        }
    }
}

