/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.clustering;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.clustering.ClusterAlgorithm;
import dev.brachtendorf.clustering.ClusterResult;
import dev.brachtendorf.clustering.distance.DistanceFunction;
import dev.brachtendorf.clustering.distance.EuclideanDistance;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class DBScan
implements ClusterAlgorithm {
    private int minPoints;
    private double eps;
    private DistanceFunction dist;

    public DBScan(int minPoints, double eps) {
        this(minPoints, eps, new EuclideanDistance());
    }

    public DBScan(int minPoints, double eps, DistanceFunction dist) {
        this.minPoints = minPoints;
        this.eps = eps;
        this.dist = dist;
    }

    @Override
    public ClusterResult cluster(double[][] data) {
        int clusters = -1;
        int[] cluster = new int[data.length];
        ArrayUtil.fillArray(cluster, () -> -2);
        for (int i = 0; i < data.length; ++i) {
            if (cluster[i] != -2) continue;
            ArrayList<Integer> neighboor = new ArrayList<Integer>();
            for (int j = 0; j < data.length; ++j) {
                if (i == j || !(this.dist.distance(data[i], data[j]) <= this.eps)) continue;
                neighboor.add(j);
            }
            if (neighboor.size() < this.minPoints) {
                cluster[i] = -1;
                continue;
            }
            cluster[i] = ++clusters;
            ListIterator<Integer> liter = neighboor.listIterator();
            while (liter.hasNext()) {
                int j = (Integer)liter.next();
                if (cluster[j] == -1) {
                    cluster[j] = clusters;
                    continue;
                }
                if (cluster[j] != -2) continue;
                cluster[j] = clusters;
                ArrayList<Integer> newNeighboots = new ArrayList<Integer>();
                for (int m = 0; m < data.length; ++m) {
                    if (m == j || !(this.dist.distance(data[m], data[j]) < this.eps)) continue;
                    newNeighboots.add(m);
                }
                if (!((double)newNeighboots.size() >= this.eps)) continue;
                Iterator iterator = newNeighboots.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    liter.add(n);
                    liter.previous();
                }
            }
        }
        return new ClusterResult(cluster, data);
    }
}

