/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.datastructures;

import dev.brachtendorf.Require;
import java.util.LinkedHashMap;
import java.util.Map;

public class CircularLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private int bufferSize = 16;

    public CircularLinkedHashMap(int bufferSize) {
        this(bufferSize, false);
        this.validatePreCondition();
    }

    public CircularLinkedHashMap(int bufferSize, boolean accessOrder) {
        super(bufferSize + 1, 1.0f, accessOrder);
        this.bufferSize = bufferSize;
        this.validatePreCondition();
    }

    public CircularLinkedHashMap(Map<? extends K, ? extends V> m) {
        super(m);
        this.bufferSize = m.size();
        this.validatePreCondition();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.bufferSize;
    }

    private void validatePreCondition() {
        Require.positiveValue(this.bufferSize, "Buffer size has to be positive");
    }
}

