/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.datastructures;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class CountHashCollection<K>
implements Collection<K> {
    private final HashMap<K, Integer> hashMap = new HashMap();
    private int elementSize;
    private int modCount = 0;

    public CountHashCollection() {
    }

    public CountHashCollection(Collection<K> c) {
        this();
        this.addAll(c);
    }

    @Override
    public boolean add(K o) {
        if (this.hashMap.containsKey(o)) {
            this.hashMap.put(o, this.hashMap.get(o) + 1);
        } else {
            this.hashMap.put(o, 1);
        }
        ++this.elementSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.hashMap.containsKey(o);
    }

    public int containsCount(K key) {
        if (this.contains(key)) {
            return this.hashMap.get(key);
        }
        return 0;
    }

    @Override
    public boolean remove(Object o) {
        if (this.hashMap.containsKey(o)) {
            --this.elementSize;
            Integer count = this.hashMap.get(o);
            if (count > 1) {
                this.hashMap.put(o, count - 1);
                ++this.modCount;
                return true;
            }
            this.hashMap.remove(o);
            ++this.modCount;
            return true;
        }
        return false;
    }

    public boolean removeFully(Object o) {
        if (this.hashMap.containsKey(o)) {
            Integer obsRemoved = this.hashMap.remove(o);
            this.elementSize -= obsRemoved.intValue();
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementSize;
    }

    public int sizeUnique() {
        return this.hashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    public K[] toArrayUnique() {
        Object[] values = this.hashMap.keySet().toArray();
        return values;
    }

    public K[] toArrayUnique(K[] array) {
        return this.hashMap.keySet().toArray(array);
    }

    @Override
    public Object[] toArray() {
        Object[] returnValues = new Object[this.elementSize];
        int curOffset = 0;
        for (Map.Entry<K, Integer> entry : this.hashMap.entrySet()) {
            K object = entry.getKey();
            Integer count = entry.getValue();
            for (int i = 0; i < count; ++i) {
                returnValues[curOffset++] = object;
            }
        }
        return this.hashMap.entrySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] r = a.length >= this.elementSize ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.elementSize);
        int curOffset = 0;
        for (Map.Entry<K, Integer> entry : this.hashMap.entrySet()) {
            K object = entry.getKey();
            Integer count = entry.getValue();
            for (int i = 0; i < count; ++i) {
                r[curOffset++] = object;
            }
        }
        if (r.length > this.elementSize) {
            a[this.elementSize] = null;
        }
        return r;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.hashMap.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean sucessfull = false;
        for (K key : c) {
            if (!this.add(key)) continue;
            sucessfull = true;
        }
        return sucessfull;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object key : c) {
            if (!this.remove(key)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iter iter = new Iter();
        boolean mofidied = false;
        while (iter.hasNext()) {
            Object entry = iter.next();
            if (c.contains(entry)) continue;
            iter.removeFully();
            mofidied = true;
        }
        return mofidied;
    }

    @Override
    public Iterator<K> iterator() {
        return new Iter();
    }

    @Override
    public void clear() {
        this.hashMap.clear();
        this.elementSize = 0;
        ++this.modCount;
    }

    public String toString() {
        int maxLen = 20;
        return "CountHashCollection " + (this.hashMap != null ? this.toString(this.hashMap.entrySet(), 20) : null);
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    class Iter
    implements Iterator<K> {
        private int elementsPresent = 0;
        private int pointer = 0;
        private int mod;
        private int arrayPointer;
        private Object[] entryArray;

        Iter() {
            this.mod = CountHashCollection.this.modCount;
            this.arrayPointer = -1;
            this.entryArray = CountHashCollection.this.hashMap.entrySet().toArray(new Object[0]);
        }

        @Override
        public boolean hasNext() {
            this.checkModcount();
            return this.pointer < this.elementsPresent || this.arrayPointer + 1 < this.entryArray.length;
        }

        @Override
        public K next() {
            this.checkModcount();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.arrayPointer == -1) {
                this.arrayPointer = 0;
                this.pointer = 0;
                this.elementsPresent = (Integer)((Map.Entry)this.entryArray[0]).getValue();
            } else if (this.pointer >= this.elementsPresent) {
                ++this.arrayPointer;
                this.pointer = 0;
                this.elementsPresent = (Integer)((Map.Entry)this.entryArray[this.arrayPointer]).getValue();
            }
            ++this.pointer;
            return ((Map.Entry)this.entryArray[this.arrayPointer]).getKey();
        }

        @Override
        public void remove() {
            this.checkModcount();
            CountHashCollection.this.remove(((Map.Entry)this.entryArray[this.arrayPointer]).getKey());
            this.mod = CountHashCollection.this.modCount;
        }

        public void removeFully() {
            this.checkModcount();
            CountHashCollection.this.removeFully(((Map.Entry)this.entryArray[this.arrayPointer]).getKey());
            this.elementsPresent = 0;
            this.mod = CountHashCollection.this.modCount;
        }

        private void checkModcount() {
            if (this.mod != CountHashCollection.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

