/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.mutable;

import dev.brachtendorf.mutable.Mutable;

public class MutableDouble
extends Number
implements Mutable<Double>,
Comparable<MutableDouble> {
    private static final long serialVersionUID = 6846548022746719522L;
    private double field;

    public MutableDouble() {
    }

    public MutableDouble(double initialValue) {
        this.field = initialValue;
    }

    @Override
    public int compareTo(MutableDouble o) {
        return Double.compare(this.field, o.field);
    }

    @Override
    public Double getValue() {
        return this.field;
    }

    @Override
    public void setValue(Double newValue) {
        this.field = newValue;
    }

    @Override
    public void setValue(double newValue) {
        this.field = newValue;
    }

    @Override
    public double doubleValue() {
        return this.field;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.field);
        return (int)(temp ^ temp >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableDouble other = (MutableDouble)obj;
        return Double.doubleToLongBits(this.field) == Double.doubleToLongBits(other.field);
    }

    @Override
    public int intValue() {
        return (int)this.field;
    }

    @Override
    public long longValue() {
        return (long)this.field;
    }

    @Override
    public float floatValue() {
        return (float)this.field;
    }
}

