/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.pcg.lock;

import com.github.kilianB.pcg.RandomBase64;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class RandomBaseLocked
extends RandomBase64 {
    private static final long serialVersionUID = 6005012112047562156L;
    private ReentrantReadWriteLock lock;
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    protected long state;
    protected long inc;

    public RandomBaseLocked() {
        this.initLocks();
    }

    public RandomBaseLocked(long seed, long streamNumber) {
        super(seed, streamNumber);
        this.initLocks();
    }

    @Deprecated
    protected RandomBaseLocked(long initialState, long increment, boolean dummy) {
        super(initialState, increment, dummy);
        this.initLocks();
    }

    @Override
    protected long stepRight() {
        this.writeLock.lock();
        long oldState = this.state;
        this.state = this.state * 6364136223846793005L + this.inc;
        this.writeLock.unlock();
        return oldState;
    }

    @Override
    public void advance(long steps) {
        long acc_mult = 1L;
        long acc_plus = 0L;
        long cur_plus = this.inc;
        long cur_mult = 6364136223846793005L;
        while (Long.compareUnsigned(steps, 0L) > 0) {
            if ((steps & 1L) == 1L) {
                acc_mult *= cur_mult;
                acc_plus = acc_plus * cur_mult + cur_plus;
            }
            cur_plus *= cur_mult + 1L;
            cur_mult *= cur_mult;
            steps = Long.divideUnsigned(steps, 2L);
        }
        this.writeLock.lock();
        this.state = acc_mult * this.state + acc_plus;
        this.writeLock.unlock();
    }

    @Override
    protected void setInc(long increment) {
        if (increment == 0L || increment % 2L == 0L) {
            throw new IllegalArgumentException("Increment may not be 0 or even. Value: " + increment);
        }
        this.writeLock.lock();
        this.inc = increment;
        this.writeLock.unlock();
    }

    @Override
    protected void setState(long initialState) {
        this.initLocks();
        this.writeLock.lock();
        this.state = initialState;
        this.writeLock.unlock();
    }

    @Override
    public boolean isFast() {
        return false;
    }

    @Override
    public long getState() {
        this.readLock.lock();
        long state = this.state;
        this.readLock.unlock();
        return state;
    }

    @Override
    public long getInc() {
        this.readLock.lock();
        long inc = this.inc;
        this.readLock.unlock();
        return inc;
    }

    private void initLocks() {
        if (this.lock == null) {
            this.lock = new ReentrantReadWriteLock();
            this.readLock = this.lock.readLock();
            this.writeLock = this.lock.writeLock();
        }
    }
}

