/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.constants;

import dev.cdevents.events.ArtifactPackagedCDEvent;
import dev.cdevents.events.ArtifactPublishedCDEvent;
import dev.cdevents.events.ArtifactSignedCDEvent;
import dev.cdevents.events.BranchCreatedCDEvent;
import dev.cdevents.events.BranchDeletedCDEvent;
import dev.cdevents.events.BuildFinishedCDEvent;
import dev.cdevents.events.BuildQueuedCDEvent;
import dev.cdevents.events.BuildStartedCDEvent;
import dev.cdevents.events.ChangeAbandonedCDEvent;
import dev.cdevents.events.ChangeCreatedCDEvent;
import dev.cdevents.events.ChangeMergedCDEvent;
import dev.cdevents.events.ChangeReviewedCDEvent;
import dev.cdevents.events.ChangeUpdatedCDEvent;
import dev.cdevents.events.EnvironmentCreatedCDEvent;
import dev.cdevents.events.EnvironmentDeletedCDEvent;
import dev.cdevents.events.EnvironmentModifiedCDEvent;
import dev.cdevents.events.IncidentDetectedCDEvent;
import dev.cdevents.events.IncidentReportedCDEvent;
import dev.cdevents.events.IncidentResolvedCDEvent;
import dev.cdevents.events.PipelinerunFinishedCDEvent;
import dev.cdevents.events.PipelinerunQueuedCDEvent;
import dev.cdevents.events.PipelinerunStartedCDEvent;
import dev.cdevents.events.RepositoryCreatedCDEvent;
import dev.cdevents.events.RepositoryDeletedCDEvent;
import dev.cdevents.events.RepositoryModifiedCDEvent;
import dev.cdevents.events.ServiceDeployedCDEvent;
import dev.cdevents.events.ServicePublishedCDEvent;
import dev.cdevents.events.ServiceRemovedCDEvent;
import dev.cdevents.events.ServiceRolledbackCDEvent;
import dev.cdevents.events.ServiceUpgradedCDEvent;
import dev.cdevents.events.TaskrunFinishedCDEvent;
import dev.cdevents.events.TaskrunStartedCDEvent;
import dev.cdevents.events.TestcaserunFinishedCDEvent;
import dev.cdevents.events.TestcaserunQueuedCDEvent;
import dev.cdevents.events.TestcaserunStartedCDEvent;
import dev.cdevents.events.TestoutputPublishedCDEvent;
import dev.cdevents.events.TestsuiterunFinishedCDEvent;
import dev.cdevents.events.TestsuiterunQueuedCDEvent;
import dev.cdevents.events.TestsuiterunStartedCDEvent;
import java.io.File;

public final class CDEventConstants {
    public static final String SPEC_REPO = ".." + File.separator + "spec";
    public static final String SCHEMA_FOLDER = SPEC_REPO + File.separator + "schemas";
    public static final String CDEVENTS_SPEC_VERSION = "0.3.0";
    public static final String EVENT_PREFIX = "dev.cdevents.";
    public static final int EVENT_SUBJECT_INDEX = 2;
    public static final int EVENT_PREDICATE_INDEX = 3;

    private CDEventConstants() {
    }

    public static enum CDEventTypes {
        PipelineRunStartedEvent("dev.cdevents.pipelinerun.started.", PipelinerunStartedCDEvent.class),
        PipelineRunFinishedEvent("dev.cdevents.pipelinerun.finished.", PipelinerunFinishedCDEvent.class),
        PipelineRunQueuedEvent("dev.cdevents.pipelinerun.queued.", PipelinerunQueuedCDEvent.class),
        TaskRunStartedEvent("dev.cdevents.taskrun.started.", TaskrunStartedCDEvent.class),
        TaskRunFinishedEvent("dev.cdevents.taskrun.finished.", TaskrunFinishedCDEvent.class),
        RepositoryCreatedEvent("dev.cdevents.repository.created.", RepositoryCreatedCDEvent.class),
        RepositoryModifiedEvent("dev.cdevents.repository.modified.", RepositoryModifiedCDEvent.class),
        RepositoryDeletedEvent("dev.cdevents.repository.deleted.", RepositoryDeletedCDEvent.class),
        BranchCreatedEvent("dev.cdevents.branch.created.", BranchCreatedCDEvent.class),
        BranchDeletedEvent("dev.cdevents.branch.deleted.", BranchDeletedCDEvent.class),
        ChangeCreatedEvent("dev.cdevents.change.created.", ChangeCreatedCDEvent.class),
        ChangeUpdatedEvent("dev.cdevents.change.updated.", ChangeUpdatedCDEvent.class),
        ChangeReviewedEvent("dev.cdevents.change.reviewed.", ChangeReviewedCDEvent.class),
        ChangeMergedEvent("dev.cdevents.change.merged.", ChangeMergedCDEvent.class),
        ChangeAbandonedEvent("dev.cdevents.change.abandoned.", ChangeAbandonedCDEvent.class),
        BuildStartedEvent("dev.cdevents.build.started.", BuildStartedCDEvent.class),
        BuildQueuedEvent("dev.cdevents.build.queued.", BuildQueuedCDEvent.class),
        BuildFinishedEvent("dev.cdevents.build.finished.", BuildFinishedCDEvent.class),
        TestCaseRunStartedEvent("dev.cdevents.testcaserun.started.", TestcaserunStartedCDEvent.class),
        TestCaseRunQueuedEvent("dev.cdevents.testcaserun.queued.", TestcaserunQueuedCDEvent.class),
        TestCaseRunFinishedEvent("dev.cdevents.testcaserun.finished.", TestcaserunFinishedCDEvent.class),
        TestSuiteRunStartedEvent("dev.cdevents.testsuiterun.started.", TestsuiterunStartedCDEvent.class),
        TestSuiteRunQueuedEvent("dev.cdevents.testsuiterun.queued.", TestsuiterunQueuedCDEvent.class),
        TestSuiteRunFinishedEvent("dev.cdevents.testsuiterun.finished.", TestsuiterunFinishedCDEvent.class),
        TestOutputPublishedEvent("dev.cdevents.testoutput.published.", TestoutputPublishedCDEvent.class),
        ArtifactPackagedEvent("dev.cdevents.artifact.packaged.", ArtifactPackagedCDEvent.class),
        ArtifactPublishedEvent("dev.cdevents.artifact.published.", ArtifactPublishedCDEvent.class),
        ArtifactSignedEvent("dev.cdevents.artifact.signed.", ArtifactSignedCDEvent.class),
        EnvironmentCreatedEvent("dev.cdevents.environment.created.", EnvironmentCreatedCDEvent.class),
        EnvironmentModifiedEvent("dev.cdevents.environment.modified.", EnvironmentModifiedCDEvent.class),
        EnvironmentDeletedEvent("dev.cdevents.environment.deleted.", EnvironmentDeletedCDEvent.class),
        IncidentDetectedEvent("dev.cdevents.incident.detected.", IncidentDetectedCDEvent.class),
        IncidentReportedEvent("dev.cdevents.incident.reported.", IncidentReportedCDEvent.class),
        IncidentResolvedEvent("dev.cdevents.incident.resolved.", IncidentResolvedCDEvent.class),
        ServiceDeployedEvent("dev.cdevents.service.deployed.", ServiceDeployedCDEvent.class),
        ServiceUpgradedEvent("dev.cdevents.service.upgraded.", ServiceUpgradedCDEvent.class),
        ServiceRolledBackEvent("dev.cdevents.service.rolledback.", ServiceRolledbackCDEvent.class),
        ServiceRemovedEvent("dev.cdevents.service.removed.", ServiceRemovedCDEvent.class),
        ServicePublishedEvent("dev.cdevents.service.published.", ServicePublishedCDEvent.class);

        private String eventType;
        private Class eventClass;

        private CDEventTypes(String event, Class eventClass) {
            this.eventType = event;
            this.eventClass = eventClass;
        }

        public String getEventType() {
            return this.eventType;
        }

        public void setEventType(String event) {
            this.eventType = event;
        }

        public Class getEventClass() {
            return this.eventClass;
        }

        public void setEventClass(Class eventClass) {
            this.eventClass = eventClass;
        }
    }

    public static enum Outcome {
        SUCCESS("success"),
        FAILURE("failure"),
        ERROR("error");

        private String outcome;

        private Outcome(String outcome) {
            this.outcome = outcome;
        }

        public String getOutcome() {
            return this.outcome;
        }

        public final void setOutcome(String outcome) {
            this.outcome = outcome;
        }
    }
}

