/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.artifact.packaged.Artifactpackaged;
import dev.cdevents.models.artifact.packaged.Change;
import dev.cdevents.models.artifact.packaged.Content;
import dev.cdevents.models.artifact.packaged.Context;
import dev.cdevents.models.artifact.packaged.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class ArtifactPackagedCDEvent
extends Artifactpackaged
implements CDEvent {
    public ArtifactPackagedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setChange(new Change());
        this.getSubject().setType(Subject.Type.ARTIFACT);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/artifact-packaged-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("artifactpackaged.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectChangeId(String id) {
        this.getSubject().getContent().getChange().setId(id);
    }

    public void setSubjectChangeSource(String source) {
        this.getSubject().getContent().getChange().setSource(source);
    }
}

