/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.build.finished.Buildfinished;
import dev.cdevents.models.build.finished.Content;
import dev.cdevents.models.build.finished.Context;
import dev.cdevents.models.build.finished.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class BuildFinishedCDEvent
extends Buildfinished
implements CDEvent {
    public BuildFinishedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().setType(Subject.Type.BUILD);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/build-finished-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("buildfinished.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectArtifactId(String artifactId) {
        this.getSubject().getContent().setArtifactId(artifactId);
    }
}

