/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.change.created.Changecreated;
import dev.cdevents.models.change.created.Content;
import dev.cdevents.models.change.created.Context;
import dev.cdevents.models.change.created.Repository;
import dev.cdevents.models.change.created.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class ChangeCreatedCDEvent
extends Changecreated
implements CDEvent {
    public ChangeCreatedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setRepository(new Repository());
        this.getSubject().setType(Subject.Type.CHANGE);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/change-created-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("changecreated.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectRepositoryId(String id) {
        this.getSubject().getContent().getRepository().setId(id);
    }

    public void setSubjectRepositorySource(String source) {
        this.getSubject().getContent().getRepository().setSource(source);
    }
}

