/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.change.merged.Changemerged;
import dev.cdevents.models.change.merged.Content;
import dev.cdevents.models.change.merged.Context;
import dev.cdevents.models.change.merged.Repository;
import dev.cdevents.models.change.merged.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class ChangeMergedCDEvent
extends Changemerged
implements CDEvent {
    public ChangeMergedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setRepository(new Repository());
        this.getSubject().setType(Subject.Type.CHANGE);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/change-merged-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("changemerged.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectRepositoryId(String id) {
        this.getSubject().getContent().getRepository().setId(id);
    }

    public void setSubjectRepositorySource(String source) {
        this.getSubject().getContent().getRepository().setSource(source);
    }
}

