/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.environment.modified.Content;
import dev.cdevents.models.environment.modified.Context;
import dev.cdevents.models.environment.modified.Environmentmodified;
import dev.cdevents.models.environment.modified.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class EnvironmentModifiedCDEvent
extends Environmentmodified
implements CDEvent {
    public EnvironmentModifiedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().setType(Subject.Type.ENVIRONMENT);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/environment-modified-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("environmentmodified.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectName(String name) {
        this.getSubject().getContent().setName(name);
    }

    public void setSubjectUrl(String url) {
        this.getSubject().getContent().setUrl(url);
    }
}

