/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.incident.detected.Content;
import dev.cdevents.models.incident.detected.Context;
import dev.cdevents.models.incident.detected.Environment;
import dev.cdevents.models.incident.detected.Incidentdetected;
import dev.cdevents.models.incident.detected.Service;
import dev.cdevents.models.incident.detected.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class IncidentDetectedCDEvent
extends Incidentdetected
implements CDEvent {
    public IncidentDetectedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setEnvironment(new Environment());
        this.getSubject().getContent().setService(new Service());
        this.getSubject().setType(Subject.Type.INCIDENT);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/incident-detected-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("incidentdetected.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectDescription(String description) {
        this.getSubject().getContent().setDescription(description);
    }

    public void setSubjectArtifactId(String artifactId) {
        this.getSubject().getContent().setArtifactId(artifactId);
    }

    public void setSubjectEnvironmentId(String id) {
        this.getSubject().getContent().getEnvironment().setId(id);
    }

    public void setSubjectEnvironmentSource(String source) {
        this.getSubject().getContent().getEnvironment().setSource(source);
    }

    public void setSubjectServiceId(String id) {
        this.getSubject().getContent().getService().setId(id);
    }

    public void setSubjectServiceSource(String source) {
        this.getSubject().getContent().getService().setSource(source);
    }
}

