/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.pipelinerun.queued.Content;
import dev.cdevents.models.pipelinerun.queued.Context;
import dev.cdevents.models.pipelinerun.queued.Pipelinerunqueued;
import dev.cdevents.models.pipelinerun.queued.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class PipelinerunQueuedCDEvent
extends Pipelinerunqueued
implements CDEvent {
    public PipelinerunQueuedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().setType(Subject.Type.PIPELINE_RUN);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/pipeline-run-queued-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("pipelinerunqueued.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectPipelineName(String pipelineName) {
        this.getSubject().getContent().setPipelineName(pipelineName);
    }

    public void setSubjectUrl(String url) {
        this.getSubject().getContent().setUrl(url);
    }
}

