/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.service.upgraded.Content;
import dev.cdevents.models.service.upgraded.Context;
import dev.cdevents.models.service.upgraded.Environment;
import dev.cdevents.models.service.upgraded.Serviceupgraded;
import dev.cdevents.models.service.upgraded.Subject;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class ServiceUpgradedCDEvent
extends Serviceupgraded
implements CDEvent {
    public ServiceUpgradedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setEnvironment(new Environment());
        this.getSubject().setType(Subject.Type.SERVICE);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/service-upgraded-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("serviceupgraded.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectArtifactId(String artifactId) {
        this.getSubject().getContent().setArtifactId(artifactId);
    }

    public void setSubjectEnvironmentId(String id) {
        this.getSubject().getContent().getEnvironment().setId(id);
    }

    public void setSubjectEnvironmentSource(String source) {
        this.getSubject().getContent().getEnvironment().setSource(source);
    }
}

