/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.taskrun.finished.Content;
import dev.cdevents.models.taskrun.finished.Context;
import dev.cdevents.models.taskrun.finished.PipelineRun;
import dev.cdevents.models.taskrun.finished.Subject;
import dev.cdevents.models.taskrun.finished.Taskrunfinished;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class TaskrunFinishedCDEvent
extends Taskrunfinished
implements CDEvent {
    public TaskrunFinishedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setPipelineRun(new PipelineRun());
        this.getSubject().setType(Subject.Type.TASK_RUN);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/task-run-finished-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("taskrunfinished.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectTaskName(String taskName) {
        this.getSubject().getContent().setTaskName(taskName);
    }

    public void setSubjectUrl(String url) {
        this.getSubject().getContent().setUrl(url);
    }

    public void setSubjectOutcome(String outcome) {
        this.getSubject().getContent().setOutcome(outcome);
    }

    public void setSubjectErrors(String errors) {
        this.getSubject().getContent().setErrors(errors);
    }

    public void setSubjectPipelineRunId(String id) {
        this.getSubject().getContent().getPipelineRun().setId(id);
    }

    public void setSubjectPipelineRunSource(String source) {
        this.getSubject().getContent().getPipelineRun().setSource(source);
    }
}

