/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.testcaserun.finished.Content;
import dev.cdevents.models.testcaserun.finished.Context;
import dev.cdevents.models.testcaserun.finished.Environment;
import dev.cdevents.models.testcaserun.finished.Subject;
import dev.cdevents.models.testcaserun.finished.TestCase;
import dev.cdevents.models.testcaserun.finished.TestSuiteRun;
import dev.cdevents.models.testcaserun.finished.Testcaserunfinished;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class TestcaserunFinishedCDEvent
extends Testcaserunfinished
implements CDEvent {
    public TestcaserunFinishedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setEnvironment(new Environment());
        this.getSubject().getContent().setTestSuiteRun(new TestSuiteRun());
        this.getSubject().getContent().setTestCase(new TestCase());
        this.getSubject().setType(Subject.Type.TEST_CASE_RUN);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/test-case-run-finished-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("testcaserunfinished.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectOutcome(Content.Outcome outcome) {
        this.getSubject().getContent().setOutcome(outcome);
    }

    public void setSubjectSeverity(Content.Severity severity) {
        this.getSubject().getContent().setSeverity(severity);
    }

    public void setSubjectReason(String reason) {
        this.getSubject().getContent().setReason(reason);
    }

    public void setSubjectEnvironmentId(String id) {
        this.getSubject().getContent().getEnvironment().setId(id);
    }

    public void setSubjectEnvironmentSource(String source) {
        this.getSubject().getContent().getEnvironment().setSource(source);
    }

    public void setSubjectTestSuiteRunId(String id) {
        this.getSubject().getContent().getTestSuiteRun().setId(id);
    }

    public void setSubjectTestSuiteRunSource(String source) {
        this.getSubject().getContent().getTestSuiteRun().setSource(source);
    }

    public void setSubjectTestCaseId(String id) {
        this.getSubject().getContent().getTestCase().setId(id);
    }

    public void setSubjectTestCaseVersion(String version) {
        this.getSubject().getContent().getTestCase().setVersion(version);
    }

    public void setSubjectTestCaseName(String name) {
        this.getSubject().getContent().getTestCase().setName(name);
    }

    public void setSubjectTestCaseType(TestCase.Type type) {
        this.getSubject().getContent().getTestCase().setType(type);
    }

    public void setSubjectTestCaseUri(URI uri) {
        this.getSubject().getContent().getTestCase().setUri(uri);
    }
}

